//Declare GL version.
#version 130

//0-1 amount of blindness.
uniform float blindness;
//0 = default, 1 = water, 2 = lava.
uniform int isEyeInWater;

//Vertex color.
varying vec4 color;

void main()
{
    vec4 col = color;

    //Calculate fog intensity in or out of water.
    float fog = (isEyeInWater>0) ? 1.-exp(-gl_FogFragCoord * gl_Fog.density):
    clamp((gl_FogFragCoord-gl_Fog.start) * gl_Fog.scale, 0., 1.);

    //Apply the fog.
	if(gl_Fog.color.rgb != vec3(0,0,0))
	{
	   col.rgb = mix(col.rgb, gl_Fog.color.rgb, fog);
	}

	

    //Output the result.
    gl_FragData[0] = col * vec4(vec3(1.-blindness),1);
}
