#version 130

#include "/settings.glsl"

varying vec2 TexCoords;
uniform sampler2D colortex0;
uniform sampler2D depthtex0;

uniform float near, far;
uniform int worldTime;
uniform float blindness;
uniform float rainStrength;

float state;
float n = near * 0.25;
float f = far;

float smoothTransition(float time) {
    if (time >= 0.0f && time <= 1000.0f) {
        return time / 1000.0f; // Transition from 0 to 1
    } else if (time > 1000.0f && time < 12000.0f) {
        return 1.0f; // Fully enabled
    } else if (time >= 12000.0f && time <= 13000.0f) {
        return 1.0f - (time - 12000.0f) / 1000.0f; // Transition from 1 to 0
    } else {
        return 0.0f; // Fully disabled
    }
}

float LinearDepth(float z) {
    return 1.0 / ((1 - f / n) * z + (f / n));
}

float FogExp2(float viewDistance, float density) {
    float factor = viewDistance * (density / sqrt(log(2.0f)));
    return exp(-factor * factor);
}

void main() {
    vec3 albedo = texture2D(colortex0, TexCoords).rgb;

	state = smoothTransition(worldTime);

    float depth = texture2D(depthtex0, TexCoords).r;
    depth = LinearDepth(depth);
    float viewDistance = depth * f - n;
	float dens = mix(FOG_DISTANCE, 1, blindness);
	dens = mix(FOG_DISTANCE + 0.10, dens, state);
    float contrastFactor = 1 - clamp(FogExp2(viewDistance, dens), 0.0f, 1.0f);
	
	vec3 fog_color = gl_Fog.color.rgb;
	float average = (fog_color.r + fog_color.g + fog_color.b) / 3.0;
	fog_color = mix(vec3(average), fog_color, 0.35);
	
	vec3 redTone = vec3(1.0, 0.2, 0.2);
	fog_color = mix(fog_color, redTone, 0.3 * state * (1 - rainStrength) * (1 - blindness));
	fog_color = mix(fog_color, vec3(0.5), 0.25 * state * rainStrength);
	
    //if (depth < 0.99999f)
	//{
	//    albedo = mix(albedo, pow(fog_color, vec3(2.2f / 1.0f)), contrastFactor);
	//}

	albedo = mix(albedo, pow(fog_color, vec3(2.2f / 1.0f)), contrastFactor);

    gl_FragData[0] = vec4(albedo, 1.0f);
}
