#version 150

#moj_import <fog.glsl>
#moj_import <fragment_utils.glsl>
#moj_import <../config.txt>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform vec4 FogColor;
uniform float FogStart;
uniform float FogEnd;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightColor;
in vec2 texCoord0;

out vec4 fragColor;

void main() {
	vec4 color = texture(Sampler0, texCoord0) * vertexColor * ColorModulator;
	
	if (Emissives) {
		float alpha = textureLod(Sampler0, texCoord0, 0.0).a * 255.0;
		if (alpha == 253) color = texture(Sampler0, texCoord0) * ColorModulator;
		color = make_emissive(color, lightColor, vertexDistance, alpha);
		color.a = remap_alpha(alpha) / 255.0;
	}
	
	if (color.a < 0.5) discard;
	fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}
