#version 150

#moj_import <fog.glsl>
#moj_import <../config.txt>

uniform sampler2D Sampler0;

uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;

in float vertexDistance;
in vec4 vertexColor;
in vec4 lightMapColor;
in vec4 overlayColor;
in vec2 texCoord0;
in vec4 normal;

out vec4 fragColor;

void default_render(vec4 color) {
    color *= vertexColor * ColorModulator;
    color.rgb = mix(overlayColor.rgb, color.rgb, overlayColor.a);
    color *= lightMapColor;
    fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
}

int getDigit(int value, int n) {
    return (value / int(pow(10, n))) % 10;
}

void main() {
    vec4 color = texture(Sampler0, texCoord0);
    if (color.a < 0.005) { discard; }
	
	default_render(color);
	
	#if defined(Player_Skin_Features)
	if (Player_Skin_Features && textureSize(Sampler0, 0) == ivec2(64, 64) && int(texelFetch(Sampler0, ivec2(63, 51), 0).a * 255.0 + 0.5) == 220 ) {
		 
		ivec4 control = ivec4(texelFetch(Sampler0, ivec2(63, 50), 0).rgba * 255.0 + 0.5);
		float Transparent = 0.0;
		float Emissive = 0.0;
		float Damage = 0.0;
		float Reflection = 0.0;
		color *= ColorModulator;
		
		if (Player_Transparency) {
			for (int i = 0; i < 8; i++) {
				for (int j = 0; j < 2; j++) {
					vec4 discardctrl = texelFetch(Sampler0, ivec2(12 + i, 16 + j), 0);
					if ( discardctrl.rgb == color.rgb ) { Transparent = 1.0; } 
				}
			} 
			if (Transparent == 1.0 && (getDigit(control.r, 1) == 1 || getDigit(control.r, 1) == 2)) { discard; }
		}
		
		if (Player_Emissives) {
			for (int i = 0; i < 8; i++) {
				for (int j = 0; j < 2; j++) {
					vec4 emissivectrl = texelFetch(Sampler0, ivec2(12 + i, 18 + j), 0);
					if ( emissivectrl.rgb == color.rgb ) { Emissive = 1.0; }
				}
			} 
			if (Emissive == 0.0 && getDigit(control.r, 0) == 1 ) { color *= lightMapColor * vertexColor; } 
			if (Emissive == 1.0 && getDigit(control.r, 0) == 2 ) { color *= lightMapColor * vertexColor; } 
			if (Emissive == 2.0 && getDigit(control.r, 0) == 3 ) { color *= lightMapColor * vertexColor; } 
		}
		
		if (Player_Hurt_Mask) {
			if (overlayColor.a < 0.99) {
				for (int i = 0; i < 8; i++) {
					for (int j = 0; j < 2; j++) {
						vec4 hurtctrl = texelFetch(Sampler0, ivec2(36 + i, 16 + j), 0);
						if (hurtctrl.rgb == color.rgb) { Damage = 0.25; }
					}
				}
				for (int i = 0; i < 8; i++) {
					for (int j = 0; j < 2; j++) {
						vec4 hurtctrl = texelFetch(Sampler0, ivec2(36 + i, 16 + j), 0);
						if (hurtctrl.rgb == color.rgb) { Damage = 1.0; }
					}
				}
			}
			if (Damage == 0.0 && getDigit(control.g, 1) == 1 ) { color.rgb = mix(color.rgb, overlayColor.rgb, Damage); } 
			if (Damage == 1.0 && getDigit(control.g, 1) == 2 ) { color.rgb = mix(color.rgb, overlayColor.rgb, Damage); } 
			if (Damage == 2.0 && getDigit(control.g, 1) == 3 ) { color.rgb = mix(color.rgb, overlayColor.rgb, Damage); } 
		}
		
		fragColor = linear_fog(color, vertexDistance, FogStart, FogEnd, FogColor);
	}
	#endif 
}
