#version 150

#moj_import <light.glsl>
#moj_import <fog.glsl>
#moj_import <vertex_utils.glsl>
#moj_import <../config.txt>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in ivec2 UV1;
in ivec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler1;
uniform sampler2D Sampler2;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform float GameTime;
uniform int FogShape;

uniform vec3 Light0_Direction;
uniform vec3 Light1_Direction;

out float vertexDistance;
out vec4 vertexColor;
out vec4 lightColor;
out vec4 lightMapColor;
out vec4 overlayColor;
out vec2 texCoord0;
out vec3 screenLocation;

void main() {
    vec3 position = Position;
    texCoord0 = UV0;
    
    vertexColor = minecraft_mix_light(Light0_Direction, Light1_Direction, Normal, Color);
    lightMapColor = texelFetch(Sampler2, UV2 / 16, 0);
    overlayColor = texelFetch(Sampler1, UV1, 0);
    
    if (Emissives) lightColor = minecraft_sample_lightmap(Sampler2, UV2);
    
    vertexDistance = fog_distance(position, FogShape);
    gl_Position = ProjMat * ModelViewMat * vec4(position, 1.0);
	
    if (Optifine == false && Ender_Chest) screenLocation = gl_Position.xyw;
}