#version 150

#moj_import <projection.glsl>

in vec3 Position;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec3 ChunkOffset;

out vec4 texProj0;

void main() {
    vec3 position = Position + ChunkOffset;
    position.y -= 0.746;
    position.y = min(position.y, 0); 

    gl_Position = ProjMat * ModelViewMat * vec4(position, 1.0);

    texProj0 = projection_from_position(gl_Position);
}
