#version 150

#moj_import <../config.txt>

in vec3 Position;
in vec4 Color;
in vec2 UV0;
in vec2 UV2;
in vec3 Normal;

uniform sampler2D Sampler0;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;

out vec4 vertexColor;
out vec2 texCoord0;
out vec2 texCoord2;
out vec4 normal;

out vec3 Pos;
out vec3 rNormal;
out mat3 mat;

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);
    Pos = Position;

    vertexColor = Color;
    texCoord0 = UV0;
    texCoord2 = UV2;

    if (Destroy_Depth > 0) {
        rNormal = normalize(IViewRotMat * Normal);
        vec3 xVec = (abs(rNormal.y) >= 0.9) ? vec3(1, 0, 0) * IViewRotMat : cross(Normal, vec3(0, 1, 0) * IViewRotMat);
        vec3 yVec = (abs(rNormal.y) >= 0.9) ? vec3(0, 0, -1) * IViewRotMat : vec3(0, 1, 0) * IViewRotMat;
        mat = mat3(xVec, yVec, Normal);
    }

    normal = ProjMat * ModelViewMat * vec4(Normal, 0.0);
}