#version 150

#moj_import <../config.txt>

uniform sampler2D Sampler0;

uniform mat3 IViewRotMat;
in vec2 UV0;

in vec4 vertexColor;
in vec2 texCoord0;
in vec2 texCoord2;

in vec3 Pos;
in vec3 rNormal;
in mat3 mat;

out vec4 fragColor;

void main() {
    vec4 color = texture(Sampler0, texCoord0) * vertexColor;
    if (color.a < 0.1) discard;

    if (Destroy_Depth > 0) {
        vec2 textureSize = textureSize(Sampler0, 0);
        vec3 viewDir = normalize(Pos * mat);
        vec2 offset = viewDir.xy / -viewDir.z / textureSize.x * Destroy_Depth;
        if (abs(rNormal.z) >= 0.9) offset.x *= -1;
        if (rNormal.y > -0.9) offset.y *= -1;
        vec4 rayColor;
        float i;
        for (float i = 1.0; i <= 16.0; i++) {
            rayColor = texture(Sampler0, texCoord0 + offset / 16.0 * i);
            if (rayColor.a < 0.1) {
                color = vec4(0.2, 0.2, 0.2, 1.0);
                break;
            }
        }
        if (i > 16.0) color = texture(Sampler0, texCoord0 + offset) * vertexColor;
    }
    fragColor = color;
}
