#version 150

in vec3 Position;
in vec4 Color;
in vec2 UV0;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform mat3 IViewRotMat;

out vec4 vertexColor;
out vec2 texCoord0;
out float y;
out vec3 relPos;
out vec3 position;

void main() {
    gl_Position = ProjMat * ModelViewMat * vec4(Position, 1.0);
    vertexColor = Color;
    texCoord0 = UV0;
    relPos = IViewRotMat * Position;
    y = 0.0;
    if (gl_VertexID % 4 == 0 || gl_VertexID % 4 == 3) y = 1024.0;
    position = Position;
}
