#version 150

#moj_import <fog.glsl>

uniform sampler2D Sampler0;

uniform mat4 ModelViewMat;
uniform mat4 ProjMat;
uniform vec4 ColorModulator;
uniform float FogStart;
uniform float FogEnd;
uniform vec4 FogColor;
uniform float GameTime;

in vec4 vertexColor;
in vec2 texCoord0;
in float y;
in vec3 relPos;
in vec3 position;

out vec4 fragColor;

mat4 dither_matrix = mat4(
    1.0 / 17.0,   9.0 / 17.0,   3.0 / 17.0,   11.0 / 17.0,
    13.0 / 17.0,  5.0 / 17.0,   15.0 / 17.0,  7.0 / 17.0,
    4.0 / 17.0,   12.0 / 17.0,  2.0 / 17.0,   10.0 / 17.0,
    16.0 / 17.0,  8.0 / 17.0,   14.0 / 17.0,  6.0 / 17.0
);

void main() {
    vec4 Color = vertexColor;
    vec2 uv = mod(texCoord0, 1.0);
    if (Color.a < 0.9) { discard;
    } else {
        uv.x += sin(GameTime * -12000.0 + y * 2.0) * 0.1;
        uv.y += sin(GameTime * -20000.0 + y * 1.0) * 0.5;
    }
    vec4 color = texture(Sampler0, uv);
    color.rgb *= color.rgb;
    color.rgb += vec3(0.3);
    float depth = gl_FragCoord.z;
    if (y < 1.0) {
        float offset = 0.0;
        if (relPos.y < y - 0.8) {
            offset = 0.2;
            color.a *= clamp(y * 4.0 - 2.0, 0.0, 1.0);
        }
        else {
            offset = -0.5;
            if (y < 0.5) color.a = 0.0;
        }
        vec4 projModelPos = ProjMat * ModelViewMat * vec4(position + vec3(0.0, 0.0, offset), 1.0);
        depth = (((gl_DepthRange.far -gl_DepthRange.near) * (projModelPos.z / projModelPos.w)) + gl_DepthRange.near + gl_DepthRange.far) / 2.0;
    }
    gl_FragDepth = depth;
    color *= Color * ColorModulator;
    if (vertexColor.a > 0.9 && color.a < dither_matrix[int(gl_FragCoord.x) % 4][int(gl_FragCoord.y) % 4]) discard;
    fragColor = color;
}
