#include "/lib/core.glsl"
#include "/lib/config.glsl"
#include "/lib/tile.glsl"

uniform sampler2D depthtex0;
uniform layout(HDR_IMG_FMT) restrict image2D colorimg1;

uniform float far;
uniform vec2 pixSize;
uniform vec3 fogColor;
uniform mat4 gbufferProjectionInverse;

#define NETHER
#include "/lib/fast_math.glsl"
#include "/lib/srgb.glsl"

void main() {
	immut ivec2 texel = ivec2(gl_GlobalInvocationID.xy);
	immut float depth = texelFetch(depthtex0, texel, 0).r;
	immut vec2 coord = fma(gl_GlobalInvocationID.xy, pixSize, 0.5 * pixSize);
	immut vec4 view_undiv = gbufferProjectionInverse * vec4(fma(vec3(coord, depth), vec3(2.0), vec3(-1.0)), 1.0);

	vec4 color;

	if (length(view_undiv.xyz / view_undiv.w) >= far) {
		color = vec4(fogColor, 0.0);
	} else color = imageLoad(colorimg1, texel);

	color.rgb = linear(color.rgb);

	imageStore(colorimg1, texel, color);
}