#include "/lib/core.glsl"
#include "/lib/config.glsl"

const ivec3 workGroups = ivec3(1, 1, 1);
layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;

#if DCG_EXP || DCG_COLOR || DCG_BP
	layout(shared, binding = 0) restrict writeonly buffer dcgBuffer {
		vec3 max_color;
		float max_luma, min_val;
	} dcg;
#endif

#if INDEXED_BLOCK_LIGHT
	layout(shared, binding = 1) restrict writeonly buffer indexWrite { uint len; } index_write;
	layout(shared, binding = 2) restrict writeonly buffer indexRead { uint len; vec3 offset; } index_read;
#endif

void main() {
	#if DCG_EXP || DCG_COLOR || DCG_BP
		dcg.max_color = vec3(1.0);
		dcg.min_val = 0.0;
		dcg.max_luma = 1.0;
	#endif

	#if INDEXED_BLOCK_LIGHT
		index_write.len = 0u;
		index_read.len = 0u;
		index_read.offset = vec3(0.0);
	#endif
}