uniform float day;
uniform vec3 cameraPositionFract;

#if defined HAND_LIGHT && !defined LIGHT_LEVELS
	const float handLight = 0.0;
#endif

#if INDEXED_BLOCK_LIGHT
	uniform usampler1D lightIndexS;
	layout(shared, binding = 2) restrict readonly buffer indexRead { uint len; vec3 offset; } index_read;
#endif

in ivec2 vaUV2;

#include "/lib/luminance.glsl"

vec3 indexed_block_light(vec3 plr, vec3 w_face_normal) {
	vec2 light = ((
		mat4(0.00390625, 0.0, 0.0, 0.0, 0.0, 0.00390625, 0.0, 0.0, 0.0, 0.0, 0.00390625, 0.0, 0.03125, 0.03125, 0.03125, 1.0) *
		vec4(vaUV2, 0.0, 1.0)
	).xy - 1.0/32.0) * 16.0/15.0; // lm_coord scaled to 0-1

	#ifdef NETHER
		const vec3 sky_light = vec3(0.3, 0.15, 0.2);
	#elif defined END
		const vec3 sky_light = vec3(0.15, 0.075, 0.2);
	#else
		immut float sky_light = 1.0 - lowp_sqrt(1.0 - max(0.1, light.y * clamp(day * 10.0, 0.25, 1.0)));
	#endif

	#ifdef LIGHT_LEVELS
		vec3 block_light = light.x > 0.0 ? mix(
			vec3(0.5, 0.25, 0.0),
			mix(
				vec3(0.75, 0.5, 0.0),
				mix(
					vec3(1.0, 0.75, 0.0),
					vec3(1.0, 1.0, 1.0),
					smoothstep(8.0, 15.0, light.x)
				),
				smoothstep(8.0, 11.0, light.x)
			),
			smoothstep(1.0, 7.0, light.x)
		) : vec3(0.5, 0.0, 0.0);
	#else
		vec3 block_light = light.xxx;
	#endif

	immut float dist = length(plr);

	#if INDEXED_BLOCK_LIGHT
		if (light.x >= 1.0/15.0 && dist < float(INDEX_DIST)) {
			vec3 shine = vec3(0.0);

			// :(
			const float default_smoothness = 0.1;
			const float reflectance = default_smoothness * default_smoothness * float(SPECULAR * 10);
			const float smoothness = fma(lowp_sqrt(default_smoothness), 3.0, 1.0);

			immut vec3 offset = -255.5 - cameraPositionFract - plr + index_read.offset;
			immut vec3 n_plr = plr / dist;

			for (int i = 0; i < index_read.len; ++i) {
				immut uvec2 light_data = texelFetch(lightIndexS, i, 0).rg;

				immut vec3 pos = vec3(
					bitfieldExtract(light_data.x, 0, 9),
					bitfieldExtract(light_data.x, 9, 9),
					bitfieldExtract(light_data.x, 18, 9)
				) + offset;

				immut float pos_len = length(pos);
				immut float brightness = bitfieldExtract(light_data.x, 27, 4);

				if (pos_len <= brightness) {
					immut vec3 n_pos = pos * lowp_rcp(pos_len);
					immut float lambertian = dot(w_face_normal, n_pos);
					immut float lighting = lambertian > 0.01 ? fma(pow(max(dot(n_plr, n_pos), 0.0), smoothness), reflectance, lambertian) : IND_ILLUM;

					shine = fma(vec3(
						bitfieldExtract(light_data.y, 22, 10),
						bitfieldExtract(light_data.y, 11, 11),
						bitfieldExtract(light_data.y, 0, 11)
					), (lighting * (brightness - pos_len)).xxx, shine);
				}
			}

			if (dot(shine, vec3(1.0)) > 0.01) {
				shine /= 15.0 * vec3(2047.0, 2047.0, 1023.0); // Undo the multiplication from packing light color and brightness

				vec3 new_light = block_light;

				immut vec3 light_color = normalize(shine);
				new_light = new_light * light_color * lowp_rcp(luminance(light_color));

				#if INDEXED_BLOCK_LIGHT
					new_light = fma((light.x * float(INDEXED_BLOCK_LIGHT)).xxx, shine, new_light);
				#endif

				block_light = mix(block_light, new_light, max(block_light - smoothstep(float(INDEX_DIST - 15), float(INDEX_DIST), dist), 0.0));
			}
		}
	#endif

	return fma(block_light, vec3(1.0, 0.8, 0.7) * lowp_rcp(1.0 + sky_light), vec3(sky_light));
}