#ifdef END
	vec3 skylight() {
		return vec3(0.19, 0.1, 0.19);
	}
#else
	uniform vec3 skyState;

	vec3 skylight() {
		const float moonlight = 0.0;
		const float sunrise = 0.05;
		const float morning = 0.3;
		const float zenith = 1.0;

		immut vec3 col_moonlight = vec3(0.69, 0.76, 0.99) * 0.025 * skyState.z;
		const vec3 col_sunrise = vec3(0.89, 0.78, 0.31) * 0.25;
		const vec3 col_morning = vec3(0.92, 0.93, 0.55);
		const vec3 col_zenith = vec3(0.93, 0.95, 0.65); // vec3(0.99, 0.99, 0.91);

		const vec3 col_overcast = vec3(0.17, 0.19, 0.25);

		return SUNLIGHT * mix(
			col_moonlight,
			mix(
				col_sunrise,
				mix(
					col_morning,
					col_zenith,
					smoothstep(morning, zenith, skyState.y)
				),
				smoothstep(sunrise, morning, skyState.y)
			),
			smoothstep(moonlight, sunrise, skyState.y)
		) * mix(vec3(1.0), col_overcast, skyState.x);
	}
#endif