uniform vec3 shadowLightDirection;
uniform sampler2D shadowcolor0;
uniform sampler2DShadow shadowtex1;

#include "/lib/brdf.glsl"

#if SHADOW_BLUR == 3
	vec3 shadow_col(float mul, vec3 pos) {
		return textureProjLod(shadowtex1, vec4(pos, shadowMapResolution), 0.0) * mul * textureProjLod(shadowcolor0, vec3(pos.xy, shadowMapResolution), 0.0).rgb;
	}
#endif

vec3 sample_shadow(
	vec3 view,
	vec3 n_view, // normalize(view)
	vec3 s_ndc, // Shadow NDC
	vec3 skylight_col // skylight()

	#ifndef NO_NORMAL
		,
		vec3 v_tex_normal,
		float face_lambertian, // dot(normal, sun)
		float smoothness // For brdf
	#endif
) {
	#ifdef NO_NORMAL
		float tex_lambertian = 1.0;
		const float brdf_val = 0.0;
	#else
		float tex_lambertian = dot(v_tex_normal, shadowLightDirection);
		immut float brdf_val = brdf(tex_lambertian, v_tex_normal, n_view, shadowLightDirection, 1.0 - smoothness) * float(SPECULAR * 0.1);
	#endif

	vec3 light = skylight_col;

	#if SSS
		immut float sss = -0.05 * min(SSS * 2.0, 20.0);
	#endif

	immut vec3 abs_pos = abs((gbufferModelViewInverse * vec4(view, 1.0)).xyz);
	immut float dist = max(abs_pos.x, max(abs_pos.y, abs_pos.z)) * lowp_rcp(shadowDistance * shadowDistanceRenderMul);

	if (dist < 1.0) {
		#if SHADOW_BLUR < 2
			#if !SHADOW_BLUR
				/*
					const bool shadowtex1Nearest = true;
				*/
			#endif

			vec3 shadow = textureLod(shadowtex1, s_ndc, 0.0) * textureLod(shadowcolor0, s_ndc.xy, 0.0).rgb;
		#else
			// Gaussean blur approximation based on: https://web.archive.org/web/20230210095515/http://the-witness.net/news/2013/09/shadow-mapping-summary-part-1/

			vec2 base_uv;
			immut vec2 st = modf(fma(s_ndc.xy, shadowMapResolution.xx, vec2(0.5)), base_uv);

			base_uv -= 0.5;

			immut float uw0 = fma(st.x, -3.0, 4.0);
			const float uw1 = 7.0;
			immut float uw2 = fma(st.x, 3.0, 1.0);

			immut float u0 = fma(st.x, -2.0, 3.0) / uw0 - 2.0;
			immut float u1 = (3.0 + st.x) / uw1;
			immut float u2 = st.x / uw2 + 2.0;

			immut float vw0 = 4.0 - 3.0 * st.y;
			const float vw1 = 7.0;
			immut float vw2 = fma(st.y, 3.0, 1.0);

			immut float v0 = fma(st.y, -2.0, 3.0) / vw0 - 2.0;
			immut float v1 = (3.0 + st.y) / vw1;
			immut float v2 = st.y / vw2 + 2.0;

			immut float depth = s_ndc.z * shadowMapResolution;

			#if SHADOW_BLUR == 2
				vec3 shadow = dot(vec3(
					dot(vec3(
						uw0 * textureProjLod(shadowtex1, vec4(base_uv + vec2(u0, v0), depth, shadowMapResolution), 0.0),
						uw1 * textureProjLod(shadowtex1, vec4(base_uv + vec2(u1, v0), depth, shadowMapResolution), 0.0),
						uw2 * textureProjLod(shadowtex1, vec4(base_uv + vec2(u2, v0), depth, shadowMapResolution), 0.0)
					), vec3(vw0)),
					dot(vec3(
						uw0 * textureProjLod(shadowtex1, vec4(base_uv + vec2(u0, v1), depth, shadowMapResolution), 0.0),
						uw1 * textureProjLod(shadowtex1, vec4(base_uv + vec2(u1, v1), depth, shadowMapResolution), 0.0),
						uw2 * textureProjLod(shadowtex1, vec4(base_uv + vec2(u2, v1), depth, shadowMapResolution), 0.0)
					), vec3(vw1)),
					dot(vec3(
						uw0 * textureProjLod(shadowtex1, vec4(base_uv + vec2(u0, v2), depth, shadowMapResolution), 0.0),
						uw1 * textureProjLod(shadowtex1, vec4(base_uv + vec2(u1, v2), depth, shadowMapResolution), 0.0),
						uw2 * textureProjLod(shadowtex1, vec4(base_uv + vec2(u2, v2), depth, shadowMapResolution), 0.0)
					), vec3(vw2))
				), vec3(1.0 / 144.0)) * textureLod(shadowcolor0, s_ndc.xy, 0.0).rgb;
			#else
				vec3 shadow = (
					vw0 * (
						shadow_col(uw0, vec3(base_uv + vec2(u0, v0), depth)) +
						shadow_col(uw1, vec3(base_uv + vec2(u1, v0), depth)) +
						shadow_col(uw2, vec3(base_uv + vec2(u2, v0), depth))
					) + vw1 * (
						shadow_col(uw0, vec3(base_uv + vec2(u0, v1), depth)) +
						shadow_col(uw1, vec3(base_uv + vec2(u1, v1), depth)) +
						shadow_col(uw2, vec3(base_uv + vec2(u2, v1), depth))
					) + vw2 * (
						shadow_col(uw0, vec3(base_uv + vec2(u0, v2), depth)) +
						shadow_col(uw1, vec3(base_uv + vec2(u1, v2), depth)) +
						shadow_col(uw2, vec3(base_uv + vec2(u2, v2), depth))
					)
				) / 144.0;
			#endif
		#endif

		immut float fade = clamp(fma(dist - 1.0, 1.0 / SHADOW_FADE_DIST, 1.0), 0.0, 1.0);

		light *= mix(shadow, vec3(1.0), fade);

		#if SSS && defined SSS_MUL
			if (tex_lambertian > 0.01 && face_lambertian > 0.01) tex_lambertian += brdf_val;
			else lambertian *= sss * (1.0 - fade); // Maybe don't invert when 0 < x < 0.01 -- ?
		#endif
	}
	#if SSS && defined SSS_MUL
		else if (lambertian > 0.01) lambertian += brdf_val;
	#else
		tex_lambertian += brdf_val;
	#endif

	return max(0.0, tex_lambertian) * light;
}