vec2 octa_encode(vec3 normal) {
	normal.xy /= dot(abs(normal), vec3(1.0));

	if (normal.z < 0.0) normal.xy = step_zero_signed(normal.xy) * (1.0 - abs(normal.yx));

	return fma(normal.xy, vec2(0.5), vec2(0.5));
}

vec3 octa_decode(vec2 octa_normal) {
	octa_normal = fma(octa_normal, vec2(2.0), vec2(-1.0));

	immut vec2 abs_on = abs(octa_normal);
	immut float z = 1.0 - abs_on.x - abs_on.y;

	return vec3(fma(max(-z, 0.0).xx, -step_zero_signed(octa_normal), octa_normal), z);
}