#if !(defined NM && defined MC_NORMAL_MAP)
	float sample_luma_offset(sampler2D source, vec2 coord, ivec2 offset) {
		#ifdef ALPHA_CHECK
			immut vec4 color = textureOffset(source, coord, offset);

			return (color.a > alphaTestRef) ? srgb_luma(color.rgb) : 0.0;
		#else
			return srgb_luma(textureOffset(source, coord, offset).rgb);
		#endif
	}

	float sample_luma(sampler2D source, vec2 coord) {
		#ifdef ALPHA_CHECK
			immut vec4 color = texture(source, coord);

			return (color.a > alphaTestRef) ? srgb_luma(color.rgb) : 0.0;
		#else
			return srgb_luma(texture(source, coord).rgb);
		#endif
	}

	vec3 implicit_normal(sampler2D source, vec2 coord, vec2 mid_coord, uint texels, vec2 atlas, float srgb_luma_val) {
		const float scale = 0.55;
		const float texel_bump = 0.5;
		const float subtexel_bump = 0.5;
		const float subtexel_scale = 0.075;

		immut vec2 local_coord = coord - mid_coord;

		immut ivec2 half_texels = ivec2(
			bitfieldExtract(texels, 0, 16),
			bitfieldExtract(texels, 16, 16)
		) / 2 - 1;

		vec4 bump = srgb_luma_val.xxxx;

		immut ivec2 local_texel = ivec2(local_coord * atlas);
		bump = mix(bump, vec4(
			sample_luma_offset(source, coord, ivec2(-1, 0)),
			sample_luma_offset(source, coord, ivec2(1, 0)),
			sample_luma_offset(source, coord, ivec2(0, -1)),
			sample_luma_offset(source, coord, ivec2(0, 1))
		), texel_bump * vec4(
			local_texel.x > -half_texels.x,
			local_texel.x < half_texels.x,
			local_texel.y > -half_texels.y,
			local_texel.y < half_texels.y
		)); // todo!() disable this on empty hand

		immut vec2 atlas_texel = 1.0 / atlas;
		immut vec2 subtexel = subtexel_scale * atlas_texel;
		immut vec2 half_size = vec2(half_texels) * atlas_texel;
		bump = mix(bump, vec4(
			sample_luma(source, coord - vec2(subtexel.x, 0.0)),
			sample_luma(source, coord + vec2(subtexel.x, 0.0)),
			sample_luma(source, coord - vec2(0.0, subtexel.y)),
			sample_luma(source, coord + vec2(0.0, subtexel.y))
		), subtexel_bump * vec4(
			local_coord.x > -half_size.x,
			local_coord.x < half_size.x,
			local_coord.y > -half_size.y,
			local_coord.y < half_size.y
		));

		return cross(max(normalize(vec3(scale, 0.0, bump.y - bump.x)), 0.01), max(normalize(vec3(0.0, scale, bump.w - bump.z)), 0.01));
	}
#endif