#include "/lib/core.glsl"
#include "/lib/config.glsl"

/* RENDERTARGETS: 1,2,3 */
layout(location = 0) out vec4 outColortex1;
layout(location = 1) out uint outColortex2;
layout(location = 2) out vec4 outColortex3;

#ifdef ALPHA_CHECK
	layout(depth_greater) out float gl_FragDepth;

	uniform float alphaTestRef;
#else
	layout(depth_unchanged) out float gl_FragDepth;
#endif

uniform mat4 gbufferModelViewInverse;
uniform sampler2D gtexture;

#ifdef NO_NORMAL
	uniform mat3 normalMatrix;
#endif

#if defined NM && defined MC_NORMAL_MAP
	uniform sampler2D normals;
#endif

#ifdef TERRAIN
	uniform ivec2 atlasSize;
#endif

in VertexData {
	vec2 coord, light;
	vec3 color;

	#ifndef NO_NORMAL
		flat mat3 tbn;
	#endif

	#if !(defined NM && defined MC_NORMAL_MAP)
		flat uint texels;
		flat vec2 mid_coord;
	#endif

	#ifdef TERRAIN
		flat uint emission;

		#if !(SM && defined MC_SPECULAR_MAP)
			flat float avg_luma;
		#endif
	#endif
} v;

#include "/lib/fast_math.glsl"
#include "/lib/octa_normal.glsl"
#include "/lib/luminance.glsl"
#include "/lib/material/specular.glsl"
#include "/lib/material/normal.glsl"

void main() {
	#ifdef TEX_ALPHA
		vec4 color = texture(gtexture, v.coord);
	#else
		vec3 color = texture(gtexture, v.coord).rgb;
	#endif

	#ifdef ALPHA_CHECK
		if (color.a < alphaTestRef) discard;
	#endif

	#ifdef NO_NORMAL
		const mat3 tbn = mat3(vec3(0.0, 1.0, 0.0), cross(vec3(0.0, 1.0, 0.0), vec3(0.0, 0.0, 1.0)), vec3(0.0, 0.0, 1.0)); // todo!() check this
	#else
		immut mat3 tbn = v.tbn;
	#endif

	#if defined NM && defined MC_NORMAL_MAP
		immut vec3 v_tex_normal = normalize(tbn * fma(texture(normals, v.coord).rgb, vec3(2.0), vec3(-1.0)));
	#else
		#ifdef TERRAIN
			immut vec2 atlas = atlasSize;
		#else
			immut vec2 atlas = textureSize(gtexture, 0);
		#endif

		immut vec3 v_tex_normal = tbn * implicit_normal(gtexture, v.coord, v.mid_coord, v.texels, atlas, srgb_luma(color.rgb));

		/*
		immut ivec2 half_texels = ivec2(
			bitfieldExtract(v.texels, 0, 16),
			bitfieldExtract(v.texels, 16, 16)
		) / 2 - 1;
		immut vec2 atlas_texel = 1.0 / atlas;
		immut vec2 half_size = vec2(half_texels) * atlas_texel;
		
		immut vec2 local_coord = v.coord - v.mid_coord;
		color.rgb += vec4(
			local_coord.x > -half_size.x,
			local_coord.x < half_size.x,
			local_coord.y > -half_size.y,
			local_coord.y < half_size.y
		).rgb;
		*/
	#endif

	outColortex3 = vec4(
		octa_encode(mat3(gbufferModelViewInverse) * tbn[2]),
		octa_encode(mat3(gbufferModelViewInverse) * v_tex_normal)
	);

	color.rgb *= v.color;

	#if SM && defined MC_SPECULAR_MAP
		immut float smoothness = map_smoothness(texture(specular, v.coord).SM_CH);
	#else
		immut float avg_luma =
			#ifdef TERRAIN
				v.avg_luma;
			#else
				0.8;
			#endif

		immut float smoothness = implicit_smoothness(srgb_luma(color.rgb), avg_luma);
	#endif

	outColortex1 = vec4(color.rgb, smoothness);

	uint packed_data = bitfieldInsert(uint(v.light.x), uint(v.light.y), 13, 13);

	// todo!() emissive map here
	#ifdef TERRAIN
		packed_data = bitfieldInsert(packed_data, v.emission, 26, 4);
	#endif

	const uint sss = 0u;
	outColortex2 = bitfieldInsert(packed_data, sss, 30, 1);
}