#include "/lib/core.glsl"
#include "/lib/config.glsl"

#ifdef PLAYER_SHADOWS
#endif
#ifdef ENTITY_SHADOWS
#endif
#ifdef BLOCK_ENTITY_SHADOWS
#endif

uniform mat4 modelViewMatrix, projectionMatrix;

#ifdef TERRAIN
	uniform vec3 chunkOffset;

	#if WAVES && defined MAYBE_FLUID
		in vec2 mc_Entity;

		#include "/lib/waves/offset.glsl"
	#endif
#endif

in vec3 vaPosition;

#ifdef TEXTURED
	uniform mat4 textureMatrix;

	in vec2 vaUV0;

	out VertexData { noperspective vec2 texel; } f;

	#ifdef TERRAIN
		uniform ivec2 atlasSize;
	#else
		uniform sampler2D gtexture;
	#endif
#endif

#include "/lib/fast_math.glsl"
#include "/lib/distort.glsl"

void main() {
	vec3 model = vaPosition;

	#ifdef TERRAIN
		model += chunkOffset;

		#if WAVES && defined MAYBE_FLUID
			if (mc_Entity.y > 0.5) model.y += wave(model.xz);
		#endif
	#endif

	immut vec4 clip = projectionMatrix * (modelViewMatrix * vec4(model, 1.0));
	gl_Position = vec4(distort(clip.xyz), clip.w);

	#ifdef TEXTURED
		#ifdef TERRAIN
			f.texel = (textureMatrix * vec4(vaUV0, 0.0, 1.0)).xy * atlasSize;
		#else
			f.texel = (textureMatrix * vec4(vaUV0, 0.0, 1.0)).xy * textureSize(gtexture, 0);
		#endif
	#endif
}