#include "/lib/core.glsl"

/* RENDERTARGETS: 0 */
layout(location = 0) out vec3 outColor;

#ifdef TEXTURED
	layout(depth_greater) out float gl_FragDepth;

	uniform float alphaTestRef;
	uniform sampler2D gtexture;

	in VertexData { noperspective vec2 texel; } v;

	#ifdef TRANSLUCENT
		#include "/lib/srgb.glsl"
	#endif
#else
	layout(depth_unchanged) out float gl_FragDepth;
#endif

void main() {
	#ifdef TEXTURED
		#ifdef TRANSLUCENT
			vec4 color = texelFetch(gtexture, ivec2(v.texel), 0);
			if (color.a < alphaTestRef) discard;

			outColor = mix(vec3(1.0), linear(color.rgb), min(step(color.a, 255.0/256.0), sqrt(color.a * 1.5))); // not pbr in the slightest, just tuned by eye
		#else
			if (texelFetch(gtexture, ivec2(v.texel), 0).a < alphaTestRef) discard;
		#endif
	#else
		outColor = vec3(1.0);
	#endif
}