#if !defined NETHER && !defined END
	uniform vec3 skyColorLinear, sunPosition;
#endif

uniform vec2 fogState;
uniform vec3 fogColor;
uniform int isEyeInWater;

float fog(float dist) {
	immut float n_dist = dist / fogState.x;
	//immut float pbr_fog = 1.0 - exp(lowp_rcp(fogState.y) * -0.25 * n_dist); // Beer–Lambert law https://discord.com/channels/237199950235041794/276979724922781697/612009520117448764
	immut float edge_fog = min(pow(n_dist, fogState.y), 1.0);

	return min(edge_fog, 1.0);
}

float sky_fog(float height) {
	return min(0.25 * lowp_rcp(fma(height, height, 0.25)) + isEyeInWater, 1.0);
}

#ifndef NETHER
	#ifdef END
		vec3 sky(vec3 n_plr) {
			return mix(rand(fma(trunc(gl_GlobalInvocationID.xy * 0.25), vec2(4.0), frameTimeCounter.xx)).xxx, rand(floor(n_plr.xz * 1024.0 + frameTimeCounter * 1)).rrr * vec3(0.05, 0.0, 0.05) * (1.25 - n_plr.y), 0.99);
		}
	#else
		vec3 sky(float sky_fog, vec3 n_view) {
			vec3 color = mix(skyColorLinear, linear(fogColor), sky_fog);

			#if SUN_BLOOM || SKY_BLOOM
				if (isEyeInWater == 0) {
					immut float view_dot_sun = dot(n_view, sunPosition * 0.01);

					immut float sun = max(0.0, view_dot_sun); // * skyState.y // make this only apply to edge fog, not pbr
					immut float moon = max(0.0, -view_dot_sun) * skyState.z * 0.2; // * (1.0 - skyState.y)

					color = fma(min(skyState.y + 0.5, 1.0) * vec3(SUN_BLOOM * pow(sun, 256u) + skyState.y * SKY_BLOOM * pow(sun, 3u)), 0.15 * skylight(), color);
					color = fma(vec3(SUN_BLOOM * pow(moon, 256u) + SKY_BLOOM * pow(moon, 3u)), vec3(0.0104, 0.0112, 0.0152), color);
				}
			#endif

			return color;
		}
	#endif
#endif