#include "/lib/rand.glsl"

vec3 unpack_un_11_11_10(uint data) {
	immut vec3 sqrt_col = vec3(
		bitfieldExtract(data, 0, 11),
		bitfieldExtract(data, 11, 11),
		bitfieldExtract(data, 22, 10)
	) / vec3(2047.0, 2047.0, 1023.0);

	return sqrt_col * sqrt_col;
}

/*
	Based on: https://github.com/GPUOpen-LibrariesAndSDKs/FidelityFX-SDK/blob/main/sdk/include/FidelityFX/gpu/fsr1/ffx_fsr1.h#L1093

	Copyright (C) 2024 Advanced Micro Devices, Inc.

	Permission is hereby granted, free of charge, to any person obtaining a copy
	of this software and associated documentation files(the "Software"), to deal
	in the Software without restriction, including without limitation the rights
	to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
	copies of the Software, and to permit persons to whom the Software is
	furnished to do so, subject to the following conditions :

	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
	THE SOFTWARE.
*/
uint pack_un11_11_10(vec3 color, uvec2 texel, float noise) {
	immut vec3 rcp_max = 1.0 / vec3(2047.0, 2047.0, 1023.0);

	immut vec3 n = floor(sqrt(color) * vec3(2047.0, 2047.0, 1023.0)) * rcp_max;
	vec3 b = n + rcp_max;
	b *= b;

	color = fma(step_zero(fract(fma(texel.x + noise, fma(sqrt(5.0), 0.5, 0.5), texel.y / 3.69)) - (color - b) / fma(n, n, -b)), rcp_max, n);

	uvec3 scaled_color = uvec3(fma(color, vec3(2047.0, 2047.0, 1023.0), vec3(0.5)));
	return bitfieldInsert(bitfieldInsert(scaled_color.r, scaled_color.g, 11, 11), scaled_color.b, 22, 10);
}

/*
vec3 dithered_gamma2(vec3 color, uvec2 texel, float noise, uint uint_max) {
	immut float rcp_max = 1.0 / uint_max;

	immut vec3 n = floor(sqrt(color) * uint_max) * rcp_max;
	vec3 b = n + rcp_max;
	b *= b;

	return fma(step_zero(fract(fma(texel.x + noise, fma(sqrt(5.0), 0.5, 0.5), texel.y / 3.69)) - (color - b) / fma(n, n, -b)), rcp_max.xxx, n);
}
*/