// Lighting & Shadows
	#define SUNLIGHT 2.5 // [0.5 0.75 1 1.25 1.5 1.75 2 2.25 2.5 2.75 3 32.25 3.5 3.75 4]
	#define AMBIENT 0.5 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
	#define PLAYER_SHADOWS
	#define ENTITY_SHADOWS
	#define BLOCK_ENTITY_SHADOWS
	#define SSS 5 // [0 1 2 3 4 5 6 7 8 9 10]
	#define SHADOW_BLUR 2 // [0 1 2 3]

	const int shadowMapResolution = 2048; // [128 256 512 1024 2048 4096 8192]
	const float shadowDistance = 160; // [16 32 48 64 80 96 112 128 144 160 176 192 208 224 240 256 272 288 304 320 336 352 368 384 400 416 432 448 464 480 496 512]

// Post Processing
	#define SATURATION 100 // [0 10 20 30 40 50 60 70 80 90 100]
	#define TONEMAP 1 // [0 1 2 3 4 5 6 7 8 9 10]
	// #define SMAA
	#define RCAS
	#define SHARPNESS 0.5 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
	#define BLOOM 0 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]
	#define BLOOM_RADIUS 0.3 // [0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

	// Dynamic Color Grading
		#define RED_MUL 100 // [0 10 20 30 40 50 60 70 80 90 100]
		#define GREEN_MUL 100 // [0 10 20 30 40 50 60 70 80 90 100]
		#define BLUE_MUL 100 // [0 10 20 30 40 50 60 70 80 90 100]
		#define DCG_EXP 5 // [0 1 2 3 4 5 6 7 8 9 10]
		#define DCG_COLOR 3 // [0 1 2 3 4 5 6 7 8 9 10]
		#define DCG_BP 7 // [0 1 2 3 4 5 6 7 8 9 10]
		#define DCG_EXP_SPEED 3.0 // [0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0]
		#define DCG_COLOR_SPEED 2.0 // [0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0]
		#define DCG_BP_SPEED 3.0 // [0.5 1.0 1.5 2.0 2.5 3.0 3.5 4.0 4.5 5.0]
		#define DCG_PEAK_SENS 5 // [1 2 3 4 5 6 7 8 9 10]
		#define DCG_MAX_BP 0.05 // [0.025 0.05 0.075 0.1 0.125 0.15 0.175 0.2]
		#define DCG_SAMPLES 16 // [2 4 8 16 32]

// Atmospherics
	#define FOG 2 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]
	#define RAIN_FOG 6 // [0 2 4 6 8 10 12 14 16 18 20 22 24 26 28 30]
	#define WATER_FOG 20 // [0 5 10 15 20 25 30 35 40 45 50]
	#define SUN_BLOOM 3 // [0 1 2 3 4 5]
	#define SKY_BLOOM 1 // [0 1 2 3 4 5]
	#define VL
	#define VL_BASE 2 // [1 2 3 4 5 6 7 8 9 10 12 14 16 18 20 25 30]
	#define VL_SUN 6 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]
	#define VL_SKY 4 // [0 1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]

	/*
		const float sunPathRotation = 25.0; // [5.0 10.0 15.0 20.0 25.0 30.0 35.0 40.0 45.0 50.0 55.0 60.0 65.0 70.0 75.0 80.0]
	*/

// Block Light
	#define INDEXED_BLOCK_LIGHT 5 // [0 1 2 3 4 5 6 7 8 9 10]
	#define IND_ILLUM 0.1 // [0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5]
	#define HAND_LIGHT
	#define EMISSIVE_REDSTONE_BLOCK
	// #define EMISSIVE_EMERALD_BLOCK
	// #define EMISSIVE_LAPIS_BLOCK

	// Light Index
		#define INDEX_DIST 128 // [32 48 64 80 96 112 128 160 192 224 256]
		#define INDEX_SIZE 3072 // [128 256 512 1024 2048 3072 4096 5120 6144 7168 8192 9216 10240 11264 12288 13312 14336 15360 16384]
		#define MIN_INDEX_LL 3 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15]
		#define INDEX_RATE 16 // [2 4 8 16 32 64 128 256]
		#define LOD_FALLOFF 3 // [1 2 3 4 5]
		#define LAVA_LOD_BIAS 0.8 // [0.0 0.2 0.4 0.6 0.8 1.0 1.2]
		#define LDS_RATIO 0.5 // [0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

// Surface
	#define WATER_OPACITY 70 // [50 60 70 80 90 100]
	#define WAVES 1 // [0 1 2 3 4 5 6 7 8 9 10]
	#define WAVE_SPEED 1.0 // [0.25 0.5 0.75 1.0 1.25 1.5 1.75 2.0]
	#define SPECULAR 8 // [1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16 17 18 19 20]
	#define SM 0 // [0 1 2 3 4 5 6 7 8 9 10]
	#define SM_CH r // [r g b a]
	#define SM_TYPE 0 // [0 1]
	// #define NM

// Misc
	#define HDR_FMT 1 // [0 1 2]
	// #define COMPASS
	// #define LIGHT_LEVELS
	#define SHADOW_FADE_DIST 0.15 // [0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5]
	#define VERSION v // [v]

const float shadowDistanceRenderMul = 0.85;

/*
	const float ambientOcclusionLevel = 0.8; // [0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

	const bool shadowcolor0Clear = false;
	const int shadowcolor0Format = RGB565;
	const bool shadowHardwareFiltering1 = true;
	const float shadowIntervalSize = 0.0;

	// fine tuned to perfection (on Iris 1.7. Maybe re-tune for the Iris 1.8 full release)
	const float shadowNearPlane = 30.0;
	const float shadowFarPlane = 213.0;

	const bool colortex0Clear = false;
	const int colortex0Format = RGBA16;

	const bool colortex1Clear = false;

	const bool colortex2Clear = false;
	const int colortex2Format = R32UI;

	const bool colortex3Clear = false;
	const int colortex3Format = RGBA8;
*/

#if HDR_FMT == 0
	/*
		const int colortex1Format = R11F_G11F_B10F;
	*/
	#define HDR_IMG_FMT r11f_g11f_b10f
#elif HDR_FMT == 1
	/*
		const int colortex1Format = RGBA16F;
	*/
	#define HDR_IMG_FMT rgba16f
#elif HDR_FMT == 2
	/*
		const int colortex1Format = RGBA32F;
	*/
	#define HDR_IMG_FMT rgba32f
#endif

/*	---Pipeline--- 
	> X marks the spot... where a write happens (in the buffer corresponding to the line)

	# --Shadow & Solid Geometry--
	shadow... : ┌> shadow -X┬>
	gtexture  : ┴-----------┼> gbuffers(solid)
	specular  : -SM---------┤   |||
	normals   : -(todo)-----┘   |||
	colortex2 :                 ||└X-> deferred
	colortex1 :                 ||      └X--------┬> deferred_1 -X->
	lightIndex: ----------------X┼┬------------X--┼>
	indexWrite: -----------------X┴> deferred_a┼X-┼>
	indexRead : -------------------------------X--┴>

	# --Translucent Geometry--
	shadow... : -------┐
	gtexture  : -------┼> gbuffers(translucent)
	specular  : -SM----┤   |
	normals   : -(todo)┤   |
	lightIndex: -------┤   |
	indexRead : -------┘   |
	colortex1 : -----------X->

	# --Post-Processing--
	dcgBuffer  : ┌> composite -X┐
	colortex1  : ┴--------------┴> composite1
	colortex0  :                    └X-> composite2 --!SMAA----┐    ┌X->
	tempCol    :                          |                    X-> composite5
	edge       :                          └SMAA-X-> composite4 |
	blendWeight:                                     └X-> composite5
*/

/* ---Packing & Layout---
	┌ colortex0 ┐
	|R |G |B |A |
	└10┴10┴10┴2 ┘
	 |  |  |  └X
	 └[unorm color]: 3x10

	┌ colortex1 ┐
	|R |G |B | A| (default format)
	└16┴16┴16┴16┘
	 |  |  |  └[smoothness]: 1x16
	 └[hdr color]: 3x16

	┌ colortex2 -┐
	|--   R    --|
	└13 13 4 1 1 ┘
	 |  |  | | └[hand]: 1x1
	 |  |  | └[sss]: 1x1
	 |  |  └[emissive]: 1x4
	 └[light]: 2x13

	┌ colortex3 ┐
	|R |G |B |A |
	└8 ┴8 ┴8 ┴8 ┘
	 |  |  |  |
	 |  |  └[texture normal]: 2x8
	 └[face normal]: 2x8

	┌--- lightIndex ---┐
	|--  R  --|-- G  --|
	└9 9 9 4 1┴11 11 10┘
	 | | | | | |  |  |
	 | | | | | └[color]: 11/11/10
	 | | | | └X
	 | | | └[brightness]: 1x4
	 └[pos]: 3x9

	// unused half-size alternative
	// not very good
	┌ lightIndex -┐
	|--    R    --|
	└7 7 7 4 2 3 2┘
	 | | | | | | |
	 | | | | └[color]: 2/3/2
	 | | | └[brightness]: 1x4
	 └[pos]: 3x8
*/