#include "/lib/pi.glsl"

float brdf(float lambertian, vec3 normal, vec3 view_dir, vec3 light_dir, float roughness) {
	const float f0 = 0.04;
	
	immut vec3 h = normalize(light_dir - view_dir);

	immut float n_v = abs(dot(normal, view_dir)) + 1.0e-5;
	immut float n_l = clamp(dot(normal, light_dir), 0.0, 1.0);
	immut float n_h = clamp(dot(normal, h), 0.0, 1.0);
	immut float l_h = clamp(dot(light_dir, h), 0.0, 1.0);

	immut float a_2 = pow(roughness, 4u);
	immut float denom = n_h * n_h * (a_2 - 1.0) + 1.0;
	immut float d = a_2 / (PI * denom * denom);

	immut float f = fma(pow(1.0 - l_h, 5.0), 1.0 - f0, f0);

	immut float a_2_inv = 1.0 - a_2;
	immut float ggx_l = n_v * sqrt(a_2_inv * n_l * n_l + a_2);
	immut float ggx_v = n_l * sqrt(a_2_inv * n_v * n_v + a_2);

	return (d * 0.5 / (ggx_v + ggx_l)) * f * smoothstep(0.01, 0.05, lambertian); // fake slightly uneven surface
}