uniform restrict writeonly image2D edge;

void main() {
	immut ivec2 texel = ivec2(gl_GlobalInvocationID.xy);

	/*
		https://github.com/iryoku/smaa/blob/master/SMAA.hlsl

		Copyright (C) 2013 Jorge Jimenez (jorge@iryoku.com)
		Copyright (C) 2013 Jose I. Echevarria (joseignacioechevarria@gmail.com)
		Copyright (C) 2013 Belen Masia (bmasia@unizar.es)
		Copyright (C) 2013 Fernando Navarro (fernandn@microsoft.com)
		Copyright (C) 2013 Diego Gutierrez (diegog@unizar.es)

		Permission is hereby granted, free of charge, to any person obtaining a copy
		this software and associated documentation files (the "Software"), to deal in
		the Software without restriction, including without limitation the rights to
		use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
		of the Software, and to permit persons to whom the Software is furnished to
		do so, subject to the following conditions:

		The above copyright notice and this permission notice shall be included in
		all copies or substantial portions of the Software. As clarification, there
		is no requirement that the copyright notice and permission be included in
		binary distributions of the Software.

		THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
		IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
		FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
		AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
		LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
		OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
		SOFTWARE.
	*/

	const float threshold = 0.05;
	const float local_contrast_adaption_factor = 2.0;

	vec4 delta;
	immut vec3 color = texelFetch(colortex0, texel, 0).rgb;

	immut vec3 left = texelFetchOffset(colortex0, texel, 0, ivec2(-1, 0)).rgb;
	vec3 t = abs(color - left);
	delta.x = max(max(t.r, t.g), t.b);

	immut vec3 top = texelFetchOffset(colortex0, texel, 0, ivec2(0, -1)).rgb;
	t = abs(color - top);
	delta.y = max(max(t.r, t.g), t.b);

	immut vec2 edges = step(threshold, delta.xy);

	vec4 detected_edges = vec4(0.0);
	
	if (dot(edges, vec2(1.0)) != 0.0) {
		immut vec3 right = texelFetchOffset(colortex0, texel, 0, ivec2(1, 0)).rgb;
		t = abs(color - right);
		delta.z = max(max(t.r, t.g), t.b);

		immut vec3 bottom = texelFetchOffset(colortex0, texel, 0, ivec2(0, 1)).rgb;
		t = abs(color - bottom);
		delta.w = max(max(t.r, t.g), t.b);

		vec2 delta_max = max(delta.xy, delta.zw);

		immut vec3 left_2 = texelFetchOffset(colortex0, texel, 0, ivec2(-2, 0)).rgb;
		t = abs(color - left_2);
		delta.z = max(max(t.r, t.g), t.b);

		immut vec3 top_2 = texelFetchOffset(colortex0, texel, 0, ivec2(0, -2)).rgb;
		t = abs(color - top_2);
		delta.w = max(max(t.r, t.g), t.b);

		delta_max = max(delta_max.xy, delta.zw);

		detected_edges.xy = edges * step(max(delta_max.x, delta_max.y), local_contrast_adaption_factor * delta.xy);
	}

	imageStore(edge, texel, detected_edges);
}