uniform vec2 pixSize;
uniform layout(r32ui) restrict writeonly uimage2D tempCol;

#include "/lib/dithered_un11_11_10.glsl"

void main() {
	immut ivec2 texel = ivec2(gl_GlobalInvocationID.xy);
	vec4 color_luma = texelFetch(colortex0, texel, 0);

	immut vec2 coord = (gl_GlobalInvocationID.xy + 0.5) * pixSize;

	/*
		https://github.com/kosua20/Rendu/blob/master/resources/common/shaders/screens/fxaa.frag

		MIT License

		Copyright (c) 2017 Simon Rodriguez

		Permission is hereby granted, free of charge, to any person obtaining a copy
		of this software and associated documentation files (the "Software"), to deal
		in the Software without restriction, including without limitation the rights
		to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
		copies of the Software, and to permit persons to whom the Software is
		furnished to do so, subject to the following conditions:

		The above copyright notice and this permission notice shall be included in all
		copies or substantial portions of the Software.

		THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
		IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
		FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
		AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
		LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
		OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
		SOFTWARE.
	*/

	immut vec4 luma = textureGatherOffsets(colortex0, coord, ivec2[](
		ivec2(0, -1), ivec2(0, 1), ivec2(-1, 0), ivec2(1, 0)
	), 3); // down, up, left, right

	immut float luma_min = min(color_luma.a, min(min(luma.x, luma.y), min(luma.z, luma.w)));
	immut float luma_max = max(color_luma.a, max(max(luma.x, luma.y), max(luma.z, luma.w)));

	immut float luma_range = luma_max - luma_min;

	if (luma_range > max(0.0312, luma_max * 0.125)) {
		immut vec4 luma2 = textureGatherOffsets(colortex0, coord, ivec2[](
			ivec2(-1, -1), ivec2(1, 1), ivec2(-1, 1), ivec2(1, -1)
		), 3); // down-left, up-right, up-left, down-right

		immut float luma_down_up = luma.x + luma.y;
		immut float luma_left_right = luma.z + luma.w;

		immut float luma_left_corners = luma2.x + luma2.z;
		immut float luma_down_corners = luma2.x + luma2.w;
		immut float luma_right_corners = luma2.w + luma2.y;
		immut float luma_up_corners = luma2.y + luma2.z;

		immut float edge_horizontal =
			abs(fma(luma.z, -2.0, luma_left_corners)) +
			abs(fma(color_luma.a, -2.0, luma_down_up)) * 2.0 +
			abs(fma(luma.w, -2.0, luma_right_corners));
		immut float edge_vertical =
			abs(fma(luma.y, -2.0, luma_up_corners)) +
			abs(fma(color_luma.a, -2.0, luma_left_right)) * 2.0 +
			abs(fma(luma.x, -2.0, luma_down_corners));

		immut bool is_horizontal = (edge_horizontal >= edge_vertical);

		immut float luma_1 = is_horizontal ? luma.x : luma.z;
		immut float luma_2 = is_horizontal ? luma.y : luma.w;
		immut float gradient_1 = abs(luma_1 - color_luma.a);
		immut float gradient_2 = abs(luma_2 - color_luma.a);

		immut float gradient_scaled = 0.25 * max(gradient_1, gradient_2);

		float step_length = is_horizontal ? pixSize.y : pixSize.x;

		float luma_local_average = 0.0;

		if (gradient_1 >= gradient_2) {
			step_length = -step_length;
			luma_local_average = 0.5 * (luma_1 + color_luma.a);
		} else {
			luma_local_average = 0.5 * (luma_2 + color_luma.a);
		}

		vec2 current_uv = coord;

		if (is_horizontal) {
			current_uv.y += step_length * 0.5;
		} else {
			current_uv.x += step_length * 0.5;
		}

		immut vec2 offset = is_horizontal ? vec2(pixSize.x, 0.0) : vec2(0.0, pixSize.y);
		vec2 uv1 = current_uv - offset;
		vec2 uv2 = current_uv + offset;

		float luma_end_1 = textureLod(colortex0, uv1, 0.0).a - luma_local_average;
		float luma_end_2 = textureLod(colortex0, uv2, 0.0).a - luma_local_average;

		bool reached_1 = abs(luma_end_1) >= gradient_scaled;
		bool reached_2 = abs(luma_end_2) >= gradient_scaled;

		bool reached_both = reached_1 && reached_2;

		if (!reached_1) uv1 -= offset;
		if (!reached_2) uv2 += offset;

		if (!reached_both) {
			const float quality[] = float[](1.0, 1.0, 1.0, 1.5, 2.0, 2.0, 2.0, 2.0, 4.0, 8.0);

			for (uint i = 0u; i < quality.length(); ++i) {
				if (!reached_1) luma_end_1 = textureLod(colortex0, uv1, 0.0).a - luma_local_average;
				if (!reached_2) luma_end_2 = textureLod(colortex0, uv2, 0.0).a - luma_local_average;

				reached_1 = abs(luma_end_1) >= gradient_scaled;
				reached_2 = abs(luma_end_2) >= gradient_scaled;
				reached_both = reached_1 && reached_2;

				if (!reached_1) uv1 = fma(offset, (-quality[i]).xx, uv1);
				if (!reached_2) uv2 = fma(offset, quality[i].xx, uv2);

				if (reached_both) break;
			}
		}

		immut float distance_1 = is_horizontal ? coord.x - uv1.x : coord.y - uv1.y;
		immut float distance_2 = is_horizontal ? uv2.x - coord.x : uv2.y - coord.y;

		immut bool correct_variation = ((distance_1 < distance_2 ? luma_end_1 : luma_end_2) < 0.0) != color_luma.a < luma_local_average;

		float final_offset = correct_variation ? -min(distance_1, distance_2) / (distance_1 + distance_2) + 0.5 : 0.0;

		immut float luma_average = (2.0 * (luma_down_up + luma_left_right) + luma_left_corners + luma_right_corners) / 12.0;
		immut float sub_pixel_offset_1 = min(abs(luma_average - color_luma.a) / luma_range, 1.0);
		immut float sub_pixel_offset_2 = fma(sub_pixel_offset_1, -2.0, 3.0) * sub_pixel_offset_1 * sub_pixel_offset_1;

		final_offset = max(final_offset, sub_pixel_offset_2 * sub_pixel_offset_2 * 0.75);

		vec2 final_uv = coord;
		final_uv[uint(is_horizontal)] += final_offset * step_length;

		color_luma.rgb = textureLod(colortex0, final_uv, 0.0).rgb;
	}

	imageStore(tempCol, texel, uvec4(pack_un11_11_10(color_luma.rgb, texel, rand(texel)), 0u, 0u, 0u));
}