#include "/lib/core.glsl"
#include "/lib/config.glsl"

uniform mat3 normalMatrix;
uniform mat4 gbufferModelViewInverse, modelViewMatrix, projectionMatrix, textureMatrix;
uniform sampler2D gtexture;

in vec2 vaUV0;
in vec3 vaNormal, vaPosition;
in vec4 vaColor;

#include "/lib/fast_math.glsl"
#include "/lib/vertex_block_light.glsl"

out VertexData {
	vec2 texel;
	vec3 color, view;
	flat vec3 normal;
} f;

void main() {
	immut vec4 view = modelViewMatrix * vec4(vaPosition, 1.0);
	gl_Position = projectionMatrix * view;

	immut vec3 normal = normalMatrix * vaNormal;

	f.texel = (textureMatrix * vec4(vaUV0, 0.0, 1.0)).xy * textureSize(gtexture, 0);
	f.color = vaColor.rgb * indexed_block_light((gbufferModelViewInverse * view).xyz, mat3(gbufferModelViewInverse) * normal);
	f.normal = normal;
	f.view = view.xyz;
}