#include "/lib/core.glsl"
#include "/lib/config.glsl"

/* RENDERTARGETS: 1 */
layout(location = 0) out vec4 outColor;
layout(depth_greater) out float gl_FragDepth;

uniform float alphaTestRef;
uniform vec3 shadowLightDirection;
uniform sampler2D gtexture;

#include "/lib/srgb.glsl"

#ifndef NO_SKYLIGHT
	#include "/lib/luminance.glsl"
	#include "/lib/skylight.glsl"
	#include "/lib/brdf.glsl"
	#include "/lib/material/specular.glsl"
#endif

in VertexData {
	vec2 texel;
	vec3 color, view;
	flat vec3 normal;
} v;

void main() {
	vec4 color = texelFetch(gtexture, ivec2(v.texel), 0);
	if (color.a < alphaTestRef) discard;

	color.a = sqrt(color.a);
	immut vec3 srgb_col = color.rgb;
	color.rgb = linear(color.rgb * v.color);

	float lambertian = dot(v.normal, shadowLightDirection);

	#ifdef NO_SKYLIGHT
		color.rgb *= mix(max(lambertian, 0.5), 1.0, 0.5);
	#else
		vec3 lighting = vec3(AMBIENT);

		if (lambertian > 0.01) {
			immut float smoothness =
				#if SM && defined MC_SPECULAR_MAP
					map_smoothness(texelFetch(specular, ivec2(v.texel), 0).SM_CH);
				#else
					implicit_smoothness(srgb_luma(srgb_col), 0.8);
				#endif

			lambertian += brdf(lambertian, normalize(v.normal), normalize(v.view), shadowLightDirection, 1.0 - smoothness) * float(SPECULAR * 0.1);

			lighting = fma(skylight(), lambertian.xxx, lighting);
		}

		color.rgb *= lighting;
	#endif

	outColor = color;
}