#include "/lib/core.glsl"
#include "/lib/config.glsl"

uniform mat3 normalMatrix;
uniform mat4 gbufferModelViewInverse, modelViewMatrix, projectionMatrix, textureMatrix;
uniform sampler2D gtexture;

#if defined HAND_LIGHT && !defined LIGHT_LEVELS
	layout(shared, binding = 3) restrict buffer handLight { uvec4 data; } hand_light;
#endif

in ivec2 vaUV2;
in vec2 vaUV0;
in vec3 vaNormal, vaPosition;
in vec4 at_tangent, vaColor;

#if INDEXED_BLOCK_LIGHT || !(defined NM && defined MC_NORMAL_MAP)
	in vec2 mc_midTexCoord;
#endif

out VertexData {
	flat uint emission;
	vec2 texel;
	flat vec2 light;
	flat vec3 color;
	flat mat3 tbn;

	#if !(defined NM && defined MC_NORMAL_MAP)
		flat uint texels;
		flat vec2 mid_coord;
	#endif
} f;

void main() {
	gl_Position = projectionMatrix * (modelViewMatrix * vec4(vaPosition, 1.0));

	/*
	#if INDEXED_BLOCK_LIGHT
		immut vec3 tex_col = textureLod(gtexture, mc_midTexCoord, 4.0).rgb;

		immut uvec3 pos = uvec3(clamp(fma(at_midBlock.xyz, vec3(1.0/64.0), 256.0 + model + cameraPositionFract), 0.0, 511.5)); // idk how i feel about this but it works
		immut uint data_r = bitfieldInsert(bitfieldInsert(bitfieldInsert(pos.x, pos.y, 9, 9), pos.z, 18, 9), uint(fma(emission, 15.0, 0.5)), 27, 4);

		// For some strange reason, multiplying with vaColor.rgb here causes flickering :/ ???
		immut uvec3 col = uvec3(fma(linear(tex_col), vec3(2047.0, 2047.0, 1023.0), vec3(0.5))); // maybe apply separateAo after this
		immut uint data_g = bitfieldInsert(bitfieldInsert(col.b, col.g, 11, 11), col.r, 22, 10);

		uvec4(data_r, data_g, 0u, 0u);
	#endif
	*/

	f.emission = 0u; // todo!()
	f.color = vaColor.rgb;
	f.light = fma(((
		mat4(0.00390625, 0.0, 0.0, 0.0, 0.0, 0.00390625, 0.0, 0.0, 0.0, 0.0, 0.00390625, 0.0, 0.03125, 0.03125, 0.03125, 1.0) *
		vec4(vaUV2, 0.0, 1.0)
	).xy - 1.0/32.0), vec2(8191.0 * 16.0/15.0), vec2(0.5));

	immut vec2 atlas = textureSize(gtexture, 0);
	immut vec2 coord = (textureMatrix * vec4(vaUV0, 0.0, 1.0)).xy;
	f.texel = coord * atlas;

	#if !(defined NM && defined MC_NORMAL_MAP)
		immut uvec2 texels = uvec2(fma(abs(coord - mc_midTexCoord), atlas * 2.0, vec2(0.5)));
		f.texels = bitfieldInsert(texels.x, texels.y, 16, 16);
		f.mid_coord = mc_midTexCoord;
	#endif

	immut vec3 normal = normalize(normalMatrix * vaNormal);
	immut vec3 tangent = normalize(normalMatrix * at_tangent.xyz);
	f.tbn = mat3(tangent, cross(tangent, normal) * at_tangent.w, normal);
}