#include "/lib/core.glsl"
#include "/lib/config.glsl"

/* RENDERTARGETS: 1,2,3 */
layout(location = 0) out vec4 outColortex1;
layout(location = 1) out uint outColortex2;
layout(location = 2) out vec4 outColortex3;
layout(depth_greater) out float gl_FragDepth;

uniform float alphaTestRef;
uniform mat4 gbufferModelViewInverse;
uniform sampler2D gtexture;

#ifdef NM
	#ifdef MC_NORMAL_MAP
		uniform sampler2D normals;
	#endif
#endif

in VertexData {
	flat uint emission;
	vec2 texel;
	flat vec2 light;
	flat vec3 color;
	flat mat3 tbn;

	#if !(defined NM && defined MC_NORMAL_MAP)
		flat uint texels;
		flat vec2 mid_coord;
	#endif
} v;

#include "/lib/fast_math.glsl"
#include "/lib/octa_normal.glsl"
#include "/lib/luminance.glsl"
#include "/lib/material/normal.glsl"
#include "/lib/material/specular.glsl"

void main() {
	immut ivec2 texel = ivec2(v.texel);
	vec4 color = texelFetch(gtexture, texel, 0);
	if (color.a < alphaTestRef) discard;

	#if defined NM && defined MC_NORMAL_MAP
		immut vec3 v_tex_normal = normalize(v.tbn * fma(texelFetch(normals, ivec2(v.texel), 0).rgb, vec3(2.0), vec3(-1.0)));
	#else
		immut vec2 atlas = textureSize(gtexture, 0);
		immut vec3 v_tex_normal = v.tbn * implicit_normal(gtexture, v.texel / atlas, v.mid_coord, v.texels, atlas, luminance(color.rgb));
	#endif

	outColortex3 = vec4(
		octa_encode(mat3(gbufferModelViewInverse) * v.tbn[2]),
		octa_encode(mat3(gbufferModelViewInverse) * v_tex_normal)
	);

	color.rgb *= v.color;

	immut float smoothness =
		#if SM && defined MC_SPECULAR_MAP
			map_smoothness(texelFetch(specular, texel, 0).SM_CH);
		#else
			implicit_smoothness(luminance(color.rgb), 0.8);
		#endif

	outColortex1 = vec4(color.rgb, smoothness);
	outColortex2 = bitfieldInsert(bitfieldInsert(
		bitfieldInsert(uint(v.light.x), uint(v.light.y), 13, 13),
		v.emission, 26, 4
	), 1u, 31, 1);
}