#include "/lib/core.glsl"
#include "/lib/config.glsl"

uniform float far;
uniform vec3 fogColor;
uniform mat4 modelViewMatrix, projectionMatrix;

in vec3 vaPosition;
in vec4 vaColor;

out VertexData { vec4 color; } f;

#include "/lib/fast_math.glsl"
#include "/lib/skylight.glsl"

void main() {
	immut vec4 view = modelViewMatrix * vec4(vaPosition, 1.0);

	immut float fog = pow(0.6 / far * length(vaPosition.xz), 0.1);

	if (fog < 0.999) {
		immut vec3 sunlight = 0.25 * skylight();

		f.color = vec4(vaColor.rgb * 0.5 + sunlight + fogColor, vaColor.a * min(length(view.xyz) * 0.01, 1.0 - fog));
	} else f.color = vec4(0.0);

	gl_Position = projectionMatrix * view;
}