#include "/lib/core.glsl"

uniform mat4 modelViewMatrix, projectionMatrix, textureMatrix;

in vec2 vaUV0;
in vec3 vaPosition;

out VertexData { vec2 coord; } f;

void main() {
	gl_Position = projectionMatrix * modelViewMatrix * vec4(vaPosition, 1.0);

	f.coord = (textureMatrix * vec4(vaUV0, 0.0, 1.0)).xy;
}