#include "/lib/core.glsl"

/* RENDERTARGETS: 1 */
layout(location = 0) out vec3 outColor;
layout(depth_greater) out float gl_FragDepth;

uniform sampler2D gtexture;
uniform float alphaTestRef;

in VertexData { vec2 coord; } v;

void main() {
	immut vec4 color = texture(gtexture, v.coord);
	if (color.a < alphaTestRef) discard;

	outColor = color.rgb;
}