#include "/lib/core.glsl"
#include "/lib/config.glsl"

#if INDEXED_BLOCK_LIGHT
	layout(local_size_x = 1024, local_size_y = 1, local_size_z = 1) in;

	uniform bool rebuildIndex;
	uniform vec3 invCameraPositionDeltaInt;
	uniform layout(rg32ui) restrict uimage1D lightIndex;

	layout(shared, binding = 1) restrict buffer indexWrite { uint len; } index_write;
	layout(shared, binding = 2) restrict buffer indexRead { uint len; vec3 offset; } index_read;

	shared uint sh_len;
	shared uint sh_culled_len;
	shared uvec2[INDEX_SIZE] sh_index;
#else
	layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;
#endif

const ivec3 workGroups = ivec3(1, 1, 1);

void main() {
	#if INDEXED_BLOCK_LIGHT
		if (rebuildIndex) {
			if (gl_LocalInvocationIndex == 0u) {
				sh_len = min(index_write.len, INDEX_SIZE);
				sh_culled_len = 0u;
			}

			barrier();

			immut uint len = sh_len;
			for (uint i = gl_LocalInvocationIndex; i < len; i += gl_WorkGroupSize.x) sh_index[i] = imageLoad(lightIndex, int(i)).rg;

			barrier();

			for (uint i = gl_LocalInvocationIndex; i < len; i += gl_WorkGroupSize.x) {
				immut uvec2 light = sh_index[i];

				bool unique = true;

				// cull identical lights
				for (uint j = 0u; j < i && unique; ++j) if (sh_index[j] == light) unique = false;

				// cull different colored lights at the same pos, using the color bits interpeted as an uint to determine which lights to keep
				for (uint j = 0u; j < len && unique; ++j) if (sh_index[j].x == light.x && sh_index[j].y < light.y) unique = false;

				if (unique) imageStore(lightIndex, int(atomicAdd(sh_culled_len, 1u)), uvec4(light, 0u, 0u));
			}

			barrier();

			if (gl_LocalInvocationIndex == 0u) {
				index_read.len = sh_culled_len;
				index_read.offset = ivec3(0u);
				index_write.len = 0u;
			}
		} else if (gl_LocalInvocationIndex == 0u) index_read.offset += invCameraPositionDeltaInt;
	#endif
}