#include "/lib/core.glsl"
#include "/lib/config.glsl"
#include "/lib/tile.glsl"

uniform float frameTimeCounter;
uniform vec2 pixSize;
uniform mat4 gbufferModelViewInverse, gbufferProjectionInverse, shadowModelView, shadowProjection;
uniform sampler2D depthtex0, colortex3;
uniform usampler2D colortex2;

uniform layout(HDR_IMG_FMT) restrict image2D colorimg1;

#if defined HAND_LIGHT && !defined LIGHT_LEVELS
	layout(shared, binding = 3) restrict readonly buffer handLight { uvec4 data; } hand_light;
#endif

#include "/lib/fast_math.glsl"
#include "/lib/srgb.glsl"
#include "/lib/skylight.glsl"
#include "/lib/sample_shadow.glsl"
#include "/lib/distort.glsl"
#include "/lib/octa_normal.glsl"
#include "/lib/rand.glsl"
#include "/lib/fog.glsl"

void main() {
	immut ivec2 texel = ivec2(gl_GlobalInvocationID.xy);
	immut float depth = texelFetch(depthtex0, texel, 0).r;
	immut vec2 coord = fma(gl_GlobalInvocationID.xy, pixSize, 0.5 * pixSize);
	immut vec3 ndc = fma(vec3(coord, depth), vec3(2.0), vec3(-1.0));
	immut vec4 view_undiv = gbufferProjectionInverse * vec4(ndc, 1.0);
	vec3 view = view_undiv.xyz / view_undiv.w;

	immut float dist = length(view);
	immut vec3 n_view = view / dist;

	immut vec3 skylight = skylight();

	vec3 color;

	#ifdef END
		immut vec3 n_plr = (mat3(gbufferModelViewInverse) * n_view).xyz;
	#endif

	float smoothness = 0.0;

	if (dist >= fogState.x) {
		#ifdef END
			color = sky(n_plr);
		#else
			immut vec3 n_plr = (mat3(gbufferModelViewInverse) * n_view).xyz;
			immut float sky_fog = sky_fog(max(n_plr.y, 0.0));

			immut float stars = max(1.0 - sky_fog - skyState.x, 0.0) * smoothstep(0.999, 1.0, rand(floor(n_plr.xz * 1000.0 + sin(frameTimeCounter * 1000.0) * 0.2)));

			immut vec3 sun_plr = mat3(gbufferModelViewInverse) * sunPosition * 0.01;
			immut bool sun = all(lessThan(abs(n_plr - sun_plr), vec3(0.04)));
			immut bool moon = all(lessThan(abs(n_plr + sun_plr), fma(skyState.z, 0.0025, 0.02).xxx));

			color = fma(skylight, vec3(moon || sun), sky(sky_fog, n_view) + stars);
		#endif
	} else {
		immut vec4 color_s = imageLoad(colorimg1, texel);
		immut vec4 octa_normal = texelFetch(colortex3, texel, 0);
		immut uint gbuffer_data = texelFetch(colortex2, texel, 0).r;

		immut mat4 g_mv_inv_s_mv_proj = shadowProjection * shadowModelView * gbufferModelViewInverse;
		vec3 lighting = AMBIENT * vec3(0.8, 0.9, 1.0);

		color = linear(color_s.rgb);
		smoothness = sqrt(color_s.a);

		immut vec3 v_face_normal = normalize(octa_decode(octa_normal.xy)) * mat3(gbufferModelViewInverse);
		immut vec3 v_tex_normal = normalize(octa_decode(octa_normal.zw)) * mat3(gbufferModelViewInverse);
		immut float face_lambertian = dot(v_face_normal, shadowLightDirection);

		if (
			//#if !SSS
				face_lambertian > 0.01
			//#endif
		) {
			if (bitfieldExtract(gbuffer_data, 31, 1) == 1u) {
				vec3 actual_ndc = ndc;
				actual_ndc.z /= MC_HAND_DEPTH;
				immut vec4 view_undiv = gbufferProjectionInverse * vec4(actual_ndc, 1.0);

				// a little janky but correct
				view = view_undiv.xyz / view_undiv.w;
			};

			immut vec3 s_ndc = distort((g_mv_inv_s_mv_proj * vec4(view, 1.0)).xyz);
			immut float bias = max(0.00008, 0.0003 * length(s_ndc.xy)) * lowp_rcp(face_lambertian);

			lighting += sample_shadow(
				view,
				n_view,
				fma(s_ndc - bias, vec3(0.5), vec3(0.5)),
				skylight,
				v_tex_normal,
				face_lambertian,
				smoothness
			);
		}

		color *= lighting;

		#ifdef VL
			immut float random = mix(rand(coord + frameTimeCounter), 0.5, 0.5);

			vec3 ray = vec3(0.0);
			const uint samples = 8u;

			for (uint i = 1u; i <= samples; ++i) {
				immut vec4 sample_pos = view_undiv + vec4(0.0, 0.0, 0.0, 0.1 * lowp_rcp(i * random));
				immut vec3 s_ndc = fma(distort((g_mv_inv_s_mv_proj * (sample_pos / sample_pos.w)).xyz), vec3(0.5), vec3(0.5));

				ray = fma(textureLod(shadowtex1, s_ndc, 0.0).rrr, textureLod(shadowcolor0, s_ndc.xy, 0.0).rgb, ray);
			}

			float brightness = VL_BASE * 0.0005;

			#if VL_SUN || VL_SKY
				immut float proximity = max(0.0, dot(normalize(view_undiv.xyz), shadowLightDirection));

				brightness += 0.01 * VL_SUN * pow(proximity, 64u) + 0.001 * VL_SKY * pow(proximity, 2u);
			#endif

			color += brightness * lowp_rcp(samples) * ray * mix(vec3(1.0), linear(fogColor) * 25.0, isEyeInWater * 0.3) * skylight;
		#endif
	}

	imageStore(colorimg1, texel, vec4(
		color,
		smoothness
	));
}