#include "/lib/core.glsl"
#include "/lib/config.glsl"

#include "/lib/tile.glsl"
layout(local_size_x = TILE, local_size_y = TILE, local_size_z = 1) in;

uniform usampler2D tempColS;
uniform layout(rgba16) restrict writeonly image2D colorimg0;

#include "/lib/fast_math.glsl"
#include "/lib/srgb.glsl"
#include "/lib/dithered_un11_11_10.glsl"

void main() {
	immut ivec2 texel = ivec2(gl_GlobalInvocationID);
	vec3 color = unpack_un_11_11_10(texelFetch(tempColS, texel, 0).r);

	#ifdef RCAS
		/*
			Based on: https://github.com/GPUOpen-LibrariesAndSDKs/FidelityFX-SDK/blob/main/sdk/include/FidelityFX/gpu/fsr1/ffx_fsr1.h#L684

			Copyright (C) 2024 Advanced Micro Devices, Inc.

			Permission is hereby granted, free of charge, to any person obtaining a copy
			of this software and associated documentation files(the "Software"), to deal
			in the Software without restriction, including without limitation the rights
			to use, copy, modify, merge, publish, distribute, sublicense, and /or sell
			copies of the Software, and to permit persons to whom the Software is
			furnished to do so, subject to the following conditions :

			The above copyright notice and this permission notice shall be included in
			all copies or substantial portions of the Software.

			THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
			IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
			FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
			AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
			LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
			OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
			THE SOFTWARE.
		*/

		immut vec3 down = unpack_un_11_11_10(texelFetchOffset(tempColS, texel, 0, ivec2(0, -1)).r);
		immut vec3 left = unpack_un_11_11_10(texelFetchOffset(tempColS, texel, 0, ivec2(-1, 0)).r);
		immut vec3 right = unpack_un_11_11_10(texelFetchOffset(tempColS, texel, 0, ivec2(1, 0)).r);
		immut vec3 up = unpack_un_11_11_10(texelFetchOffset(tempColS, texel, 0, ivec2(0, 1)).r);

		immut vec3 mn4 = min(min(down, left), min(right, up));
		immut vec3 mx4 = max(max(down, left), max(right, up));

		immut vec3 lobe_rgb = max(mn4 / (mx4 * -4.0), (1.0 - mx4) / fma(mn4, vec3(4.0), vec3(-4.0)));
		float lobe = clamp(max(lobe_rgb.r, max(lobe_rgb.g, lobe_rgb.b)), -0.1875, 0.0) * SHARPNESS;

		// Denoise
		immut float down_L = fma(down.b + down.r, 0.5, down.g);
		immut float left_L = fma(left.b + left.r, 0.5, left.g);
		immut float right_L = fma(right.b + right.r, 0.5, right.g);
		immut float up_L = fma(up.b + up.r, 0.5, up.g); //not much, what's up with you?

		immut float noise = abs(dot(vec4(down_L, left_L, right_L, up_L), vec4(0.25)) - 0.5 * (color.b + color.r) - color.g);

		lobe *= fma(clamp(noise / (max(max(down_L, left_L), max(right_L, up_L)) - min(min(down_L, left_L), min(right_L, up_L))), 0.0, 1.0), -0.5, 1.0);

		color = fma(down + left + right + up, lobe.xxx, color) / fma(lobe, 4.0, 1.0);
	#endif

	// color.rb += vec2(equal(gl_LocalInvocationID.xy, uvec2(0u)));

	imageStore(colorimg0, texel, vec4(srgb(color), 0.0));
}