#include "/lib/core.glsl"

#include "/lib/tile.glsl"
layout(local_size_x = TILE, local_size_y = TILE, local_size_z = 1) in;

uniform layout(r32ui) restrict writeonly uimage2D tempCol;
uniform sampler2D colortex0, blendWeightS;
uniform vec2 pixSize;

/*
	https://github.com/iryoku/smaa/blob/master/SMAA.hlsl

	Copyright (C) 2013 Jorge Jimenez (jorge@iryoku.com)
	Copyright (C) 2013 Jose I. Echevarria (joseignacioechevarria@gmail.com)
	Copyright (C) 2013 Belen Masia (bmasia@unizar.es)
	Copyright (C) 2013 Fernando Navarro (fernandn@microsoft.com)
	Copyright (C) 2013 Diego Gutierrez (diegog@unizar.es)

	Permission is hereby granted, free of charge, to any person obtaining a copy
	this software and associated documentation files (the "Software"), to deal in
	the Software without restriction, including without limitation the rights to
	use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies
	of the Software, and to permit persons to whom the Software is furnished to
	do so, subject to the following conditions:

	The above copyright notice and this permission notice shall be included in
	all copies or substantial portions of the Software. As clarification, there
	is no requirement that the copyright notice and permission be included in
	binary distributions of the Software.

	THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
	IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
	FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
	AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
	LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
	OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
	SOFTWARE.
*/

#include "/lib/fast_math.glsl"
#include "/lib/dithered_un11_11_10.glsl"

void main() {
	immut ivec2 texel = ivec2(gl_GlobalInvocationID.xy);

	immut vec4 a = vec4(
		texelFetchOffset(blendWeightS, texel, 0, ivec2(1, 0)).a,
		texelFetchOffset(blendWeightS, texel, 0, ivec2(0, 1)).g,
		texelFetch(blendWeightS, texel, 0).br
	);

	vec3 color;

	if (dot(a, vec4(1.0)) < 1.0e-5) {
		color = texelFetch(colortex0, texel, 0).rgb;
	} else {
		immut bool h = max(a.x, a.z) > max(a.y, a.w);

		immut vec4 blending_offset = h ? vec4(a.x, 0.0, a.z, 0.0) : vec4(0.0, a.y, 0.0, a.w);

		vec2 blending_weight = h ? a.xz : a.yw;
		blending_weight /= dot(blending_weight, vec2(1.0));

		immut vec4 blending_coord = fma(blending_offset, vec4(pixSize, -pixSize), ((gl_GlobalInvocationID.xy + 0.5) * pixSize).xyxy);

		color = blending_weight.x * textureLod(colortex0, blending_coord.xy, 0.0).rgb;
		color += blending_weight.y * textureLod(colortex0, blending_coord.zw, 0.0).rgb;
	}

	imageStore(tempCol, texel, uvec4(pack_un11_11_10(color, texel, rand(texel)), 0u, 0u, 0u)); // maybe this gamma2 could just be sqrt?
}