#include "/lib/core.glsl"
#include "/lib/config.glsl"

// todo!() Just disable this program entirely when DCG is disabled
const ivec3 workGroups = ivec3(1, 1, 1);

#if DCG_EXP || DCG_COLOR || DCG_BP
	layout(local_size_x = 8, local_size_y = 8, local_size_z = 1) in;

	uniform float frameTime;
	uniform sampler2D colortex1;

	//uniform vec2 pixSize; uniform layout(rgb10_a2) restrict writeonly image2D colorimg1;

	layout(shared, binding = 0) restrict buffer dcgBuffer {
		vec3 max_color;
		float max_luma, min_val;
	} dcg;

	//#include "/lib/luminance.glsl"
	#include "/lib/tonemap.glsl"
#else
	layout(local_size_x = 1, local_size_y = 1, local_size_z = 1) in;
#endif

shared uint sh_min_val;
shared uvec3 sh_max_color;

void main() {
	#if DCG_EXP || DCG_COLOR || DCG_BP
		if (gl_LocalInvocationIndex == 0u) {
			sh_min_val = uint(fma(DCG_MAX_BP, float(0x00FFFFFFu), 0.5));
			sh_max_color = uvec3(0u);
		}

		barrier();

		vec3 max_color = vec3(0.0);
		float min_val = DCG_MAX_BP;

		immut vec2 local_coord = (vec2(gl_LocalInvocationID.xy) + 0.5) / vec2(gl_WorkGroupSize.xy * DCG_SAMPLES);

		for (uint x = 0u; x < DCG_SAMPLES; ++x) for (uint y = 0u; y < DCG_SAMPLES; ++y) {
			immut vec2 coord = vec2(x, y) / float(DCG_SAMPLES) + local_coord;
			immut vec3 color = textureLod(colortex1, coord, 0.0).rgb;
			//imageStore(colorimg1, ivec2(coord / pixSize), vec4(1.0, 1.0, 1.0, 0.0));

			min_val = min(min(min_val, color.r), min(color.g, color.b));
			max_color = mix(max(max_color, color), max_color, exp2(-DCG_PEAK_SENS * 0.075 / float(DCG_SAMPLES)));
		}

		atomicMin(sh_min_val, uint(fma(max(min_val, 0.0), float(0x00FFFFFFu), 0.5)));

		immut uvec3 scaled_max = uvec3(fma(clamp(max_color, 0.0, 1.0), vec3(0x0000FFFF), vec3(0.5)));
		atomicAdd(sh_max_color.r, scaled_max.r);
		atomicAdd(sh_max_color.g, scaled_max.g);
		atomicAdd(sh_max_color.b, scaled_max.b);

		barrier();

		if (gl_LocalInvocationIndex == 0u) {
			min_val = tonemap((float(sh_min_val) * (DCG_BP * 0.1 / float(0x00FFFFFFu))).rrr).r;
			max_color = pow(vec3(sh_max_color) / float(0x0000FFFF * gl_WorkGroupSize.x * gl_WorkGroupSize.y), vec3(0.06 * DCG_EXP));

			immut float max_luma = luminance(max_color);
			max_color = mix(vec3(max_luma), max_color, 0.1 * DCG_COLOR) - min_val;
			
			dcg.max_color = mix(max_color, dcg.max_color, exp2(-DCG_COLOR_SPEED * frameTime));
			dcg.min_val = mix(min_val, dcg.min_val, exp2(-DCG_BP_SPEED * frameTime));
			dcg.max_luma = mix(max_luma, dcg.max_luma, exp2(-DCG_EXP_SPEED * frameTime));
		}
	#endif
}