/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.config;

import com.aizistral.nochatreports.common.NCRClient;
import com.aizistral.nochatreports.common.config.JSONConfig;
import com.aizistral.nochatreports.common.core.ServerSafetyState;
import com.aizistral.nochatreports.common.core.SigningMode;
import java.util.HashMap;
import net.minecraft.class_639;
import org.jetbrains.annotations.Nullable;

public class NCRServerPreferences
extends JSONConfig {
    protected static final String FILE_NAME = "NoChatReports/NCR-ServerPreferences.json";
    protected HashMap<class_639, SigningMode> signingModes = new HashMap();

    protected NCRServerPreferences() {
        super(FILE_NAME);
    }

    @Override
    public NCRServerPreferences getDefault() {
        return new NCRServerPreferences();
    }

    public SigningMode getModeRaw(@Nullable class_639 address) {
        return this.signingModes.get(address);
    }

    public SigningMode getModeUnresolved(@Nullable class_639 address) {
        if (!NCRClient.areSigningKeysPresent()) {
            return SigningMode.NEVER_FORCED;
        }
        if (ServerSafetyState.isInSingleplayer()) {
            return SigningMode.NEVER;
        }
        if (ServerSafetyState.isOnRealms()) {
            return SigningMode.ALWAYS;
        }
        if (address == null) {
            return SigningMode.DEFAULT;
        }
        SigningMode mode = this.getModeRaw(address);
        return mode != null ? mode : SigningMode.DEFAULT;
    }

    public SigningMode getMode(@Nullable class_639 address) {
        return this.getModeUnresolved(address).resolve();
    }

    public boolean hasMode(@Nullable class_639 address, SigningMode mode) {
        return this.getMode(address) == mode;
    }

    public boolean hasModeCurrent(SigningMode mode) {
        return this.hasMode(ServerSafetyState.getLastServer(), mode);
    }

    public void setMode(@Nullable class_639 address, @Nullable SigningMode mode) {
        if (address == null) {
            return;
        }
        if (mode == null || mode == SigningMode.DEFAULT) {
            this.signingModes.remove(address);
        } else {
            this.signingModes.put(address, mode);
        }
    }
}

