/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.picker;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import io.github.sjouwer.pickblockpro.util.EnchantmentUtil;
import io.github.sjouwer.pickblockpro.util.InfoProvider;
import io.github.sjouwer.pickblockpro.util.InventoryManager;
import java.util.ArrayList;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1299;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_9285;
import net.minecraft.class_9334;

public class WeaponPicker {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig config = PickBlockPro.getConfig();

    private static class_1799 findBestWeapon(class_1299<?> entityType) {
        class_1661 inventory = WeaponPicker.client.field_1724.method_31548();
        class_1799 bestSword = class_1799.field_8037;
        boolean foundSword = false;
        double bestSwordScore = -1.0;
        for (int i = 0; i < 36; ++i) {
            class_1799 itemStack = inventory.method_5438(i);
            double score = WeaponPicker.calculateWeaponScore(itemStack, entityType);
            if (score <= 0.0) continue;
            foundSword = true;
            if (itemStack.method_7936() - itemStack.method_7919() <= config.durabilityThreshold() || !(score > bestSwordScore) && (bestSword.method_7960() || score != bestSwordScore || itemStack.method_7919() >= bestSword.method_7919())) continue;
            bestSword = itemStack;
            bestSwordScore = score;
        }
        if (foundSword && bestSword.method_7960()) {
            InfoProvider.sendWarning(class_2561.method_43471((String)"text.pickblockpro.message.allWeaponsBelowThreshold"));
        }
        return bestSword;
    }

    private static double calculateWeaponScore(class_1799 itemStack, class_1299<?> entityType) {
        double score = 0.0;
        score += WeaponPicker.getBaseDamage(itemStack);
        score += EnchantmentUtil.getItemEnchantmentsTotalDamage(itemStack, entityType);
        if (config.getBowPreferenceList().contains(entityType)) {
            score += itemStack.method_31574(class_1802.field_8102) ? 200.0 : 0.0;
            score += itemStack.method_31574(class_1802.field_8399) ? 100.0 : 0.0;
        }
        if (config.getTridentPreferenceList().contains(entityType)) {
            score += itemStack.method_31574(class_1802.field_8547) ? 100.0 : 0.0;
        }
        return score;
    }

    private static double getBaseDamage(class_1799 stack) {
        ArrayList baseDamage = new ArrayList();
        ((class_9285)stack.method_57825(class_9334.field_49636, (Object)class_9285.field_49326)).comp_2393().forEach(m -> {
            if (m.method_60767(class_5134.field_23721, class_1792.field_8006)) {
                baseDamage.add(m.comp_2396().comp_2449());
            }
        });
        return baseDamage.stream().reduce(0.0, Double::sum);
    }

    public static void giveWeapon(Weapons weapon) {
        if (!WeaponPicker.client.field_1724.method_7337()) {
            InfoProvider.sendError(class_2561.method_43471((String)"text.pickblockpro.message.creativeRequired"));
            return;
        }
        class_1799 toolStack = config.getWeaponItemStack(weapon);
        InventoryManager.pickOrPlaceItemInInventory(toolStack);
    }

    protected static void giveOrSwitchWeapon(class_1299<?> entityType) {
        class_1799 bestWeapon;
        class_1799 class_17992 = bestWeapon = WeaponPicker.client.field_1724.method_7337() ? WeaponPicker.createBestWeapon(entityType) : WeaponPicker.findBestWeapon(entityType);
        if (!bestWeapon.method_7960()) {
            InventoryManager.pickOrPlaceItemInInventory(bestWeapon);
        }
    }

    public static class_1799 createBestWeapon(class_1299<?> entityType) {
        Weapons weapon = WeaponPicker.getMostSuitableWeapon(entityType);
        if (weapon == null) {
            return class_1799.field_8037;
        }
        return config.getWeaponItemStack(weapon, entityType);
    }

    private static Weapons getMostSuitableWeapon(class_1299<?> entityType) {
        if (config.getBowPreferenceList().contains(entityType)) {
            return Weapons.BOW;
        }
        if (config.getTridentPreferenceList().contains(entityType)) {
            return Weapons.TRIDENT;
        }
        return Weapons.SWORD;
    }

    public static void addConfiguredWeaponsToOpUtilities() {
        if (config.addWeaponsToOpUtilities() && config.enchantWeapons()) {
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41063).register(entries -> {
                for (Weapons weapon : Weapons.values()) {
                    if (weapon == Weapons.AXE && config.addToolsToOpUtilities()) continue;
                    entries.method_45420(config.getWeaponItemStack(weapon));
                }
            });
        }
    }

    public static enum Weapons {
        SWORD,
        AXE,
        BOW,
        CROSSBOW,
        TRIDENT,
        MACE;

    }
}

