/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.picker;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import io.github.sjouwer.pickblockpro.picker.WeaponPicker;
import io.github.sjouwer.pickblockpro.util.EnchantmentUtil;
import io.github.sjouwer.pickblockpro.util.InfoProvider;
import io.github.sjouwer.pickblockpro.util.InventoryManager;
import io.github.sjouwer.pickblockpro.util.RaycastUtil;
import java.util.Arrays;
import java.util.List;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_3489;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5321;
import net.minecraft.class_7706;
import net.minecraft.class_8170;

public class ToolPicker {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig config = PickBlockPro.getConfig();
    private static final List<class_2248> shearable = Arrays.asList(class_2246.field_10343, class_2246.field_10597, class_2246.field_28675, class_2246.field_28676, class_2246.field_22123, class_2246.field_23078, class_2246.field_10428, class_2246.field_10112, class_2246.field_10313, class_2246.field_28411, class_2246.field_28686, class_2246.field_10479, class_2246.field_10214, class_2246.field_10376, class_2246.field_10238, class_2246.field_10589, class_2246.field_22117);

    private ToolPicker() {
    }

    public static void pickTool() {
        if (ToolPicker.client.field_1724 == null || ToolPicker.client.field_1687 == null) {
            PickBlockPro.LOGGER.error("Pick Tool called outside of play; no world and/or player");
            return;
        }
        class_239 hit = RaycastUtil.getHit(config.blockToolPickRange((class_1657)ToolPicker.client.field_1724), config.entityToolPickRange((class_1657)ToolPicker.client.field_1724), !config.toolPickFluids(), false);
        if (hit == null || hit.method_17783() == class_239.class_240.field_1333) {
            return;
        }
        if (hit.method_17783() == class_239.class_240.field_1331) {
            class_1297 entity = ((class_3966)hit).method_17782();
            if (entity instanceof class_1309) {
                class_1309 livingEntity = (class_1309)entity;
                WeaponPicker.giveOrSwitchWeapon(livingEntity.method_5864());
            }
        } else {
            class_2338 blockPos = ((class_3965)hit).method_17777();
            class_2680 state = ToolPicker.client.field_1687.method_8320(blockPos);
            ToolPicker.giveOrSwitchTool(state);
        }
    }

    private static class_1799 findBestTool(class_2680 state) {
        class_1661 inventory = ToolPicker.client.field_1724.method_31548();
        class_1799 bestTool = class_1799.field_8037;
        boolean foundTool = false;
        float bestToolScore = -1.0f;
        for (int i = 0; i < 36; ++i) {
            float score;
            class_1799 stack = inventory.method_5438(i);
            if (!ToolPicker.isSuitableTool(stack, state)) continue;
            foundTool = true;
            if (stack.method_7919() > 0 && stack.method_7936() - stack.method_7919() <= config.durabilityThreshold() || !((score = ToolPicker.calculateToolScore(stack, state)) > bestToolScore) && (bestTool.method_7960() || score != bestToolScore || stack.method_7919() >= bestTool.method_7919())) continue;
            bestTool = stack;
            bestToolScore = score;
        }
        if (foundTool && bestTool.method_7960()) {
            InfoProvider.sendWarning(class_2561.method_43471((String)"text.pickblockpro.message.allToolsBelowThreshold"));
        }
        return bestTool;
    }

    private static boolean isSuitableTool(class_1799 stack, class_2680 state) {
        if (stack.method_31574(class_1802.field_8868) && (state.method_26164(class_3481.field_15481) || shearable.contains(state.method_26204()))) {
            return true;
        }
        if (stack.method_31573(class_3489.field_42611) && state.method_27852(class_2246.field_10211)) {
            return true;
        }
        if (stack.method_31574(class_1802.field_8550) && (state.method_51176() || state.method_27852(class_2246.field_27879))) {
            return true;
        }
        if (stack.method_31574(class_1802.field_42716) && state.method_26204() instanceof class_8170) {
            return true;
        }
        return stack.method_7951(state);
    }

    private static float calculateToolScore(class_1799 stack, class_2680 state) {
        class_1792 class_17922;
        float score = 0.0f;
        if (stack.method_31573(class_3489.field_42611) && state.method_27852(class_2246.field_10211) && config.preferSwordForBamboo() || stack.method_31574(class_1802.field_8868) && shearable.contains(state.method_26204()) || state.method_26204() instanceof class_8170) {
            score += 1.0E8f;
        }
        if ((class_17922 = stack.method_7909()) instanceof class_1831) {
            class_1831 toolItem = (class_1831)class_17922;
            score += toolItem.method_8022().method_8027() * (float)toolItem.method_8022().method_8025() * 1000.0f;
        }
        if (config.preferSilkTouch()) {
            score += (float)(EnchantmentUtil.getLevel((class_5321<class_1887>)class_1893.field_9099, stack) * 400);
            score += (float)(EnchantmentUtil.getLevel((class_5321<class_1887>)class_1893.field_9130, stack) * 100);
        } else {
            score += (float)(EnchantmentUtil.getLevel((class_5321<class_1887>)class_1893.field_9130, stack) * 150);
            score += (float)(EnchantmentUtil.getLevel((class_5321<class_1887>)class_1893.field_9099, stack) * 100);
        }
        score = config.preferEfficiency() ? (score += (float)(EnchantmentUtil.getLevel((class_5321<class_1887>)class_1893.field_9131, stack) * 500)) : (score += (float)(EnchantmentUtil.getLevel((class_5321<class_1887>)class_1893.field_9131, stack) * 10));
        score += (float)EnchantmentUtil.getLevel((class_5321<class_1887>)class_1893.field_9119, stack);
        return score += (float)(EnchantmentUtil.getLevel((class_5321<class_1887>)class_1893.field_9101, stack) * 5);
    }

    public static void giveTool(Tools tool) {
        if (!ToolPicker.client.field_1724.method_7337()) {
            InfoProvider.sendError(class_2561.method_43471((String)"text.pickblockpro.message.creativeRequired"));
            return;
        }
        class_1799 toolStack = config.getToolItemStack(tool);
        InventoryManager.pickOrPlaceItemInInventory(toolStack);
    }

    private static void giveOrSwitchTool(class_2680 state) {
        class_1799 bestTool;
        class_1799 class_17992 = bestTool = ToolPicker.client.field_1724.method_7337() ? ToolPicker.createBestTool(state) : ToolPicker.findBestTool(state);
        if (!bestTool.method_7960()) {
            InventoryManager.pickOrPlaceItemInInventory(bestTool);
        }
    }

    public static class_1799 createBestTool(class_2680 state) {
        Tools tool = ToolPicker.getMostSuitableTool(state);
        if (tool == null) {
            return class_1799.field_8037;
        }
        return config.getToolItemStack(tool);
    }

    private static Tools getMostSuitableTool(class_2680 state) {
        if (state.method_26164(class_3481.field_15481) || shearable.contains(state.method_26204())) {
            return Tools.SHEARS;
        }
        if (state.method_27852(class_2246.field_10211) && config.preferSwordForBamboo()) {
            return Tools.SWORD;
        }
        if (state.method_26204() instanceof class_8170) {
            return Tools.BRUSH;
        }
        if (state.method_51176() || state.method_27852(class_2246.field_27879)) {
            return Tools.BUCKET;
        }
        if (state.method_26164(class_3481.field_33715)) {
            return Tools.PICKAXE;
        }
        if (state.method_26164(class_3481.field_33713)) {
            return Tools.AXE;
        }
        if (state.method_26164(class_3481.field_33716)) {
            return Tools.SHOVEL;
        }
        if (state.method_26164(class_3481.field_33714)) {
            return Tools.HOE;
        }
        return null;
    }

    public static void addConfiguredToolsToOpUtilities() {
        if (config.addToolsToOpUtilities() && config.enchantTools()) {
            ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_41063).register(entries -> {
                for (Tools tool : Tools.values()) {
                    if (tool == Tools.BUCKET || tool == Tools.SWORD && config.addWeaponsToOpUtilities()) continue;
                    entries.method_45420(config.getToolItemStack(tool));
                }
            });
        }
    }

    public static enum Tools {
        PICKAXE,
        AXE,
        SHOVEL,
        HOE,
        SWORD,
        SHEARS,
        BUCKET,
        FISHING_ROD,
        BRUSH;

    }
}

