/*
 * Decompiled with CFR 0.152.
 */
package io.github.sjouwer.pickblockpro.picker;

import io.github.sjouwer.pickblockpro.PickBlockPro;
import io.github.sjouwer.pickblockpro.config.ModConfig;
import io.github.sjouwer.pickblockpro.mixin.BucketItemAccessor;
import io.github.sjouwer.pickblockpro.mixin.VerticallyAttachableBlockItemAccessor;
import io.github.sjouwer.pickblockpro.util.DataComponentUtil;
import io.github.sjouwer.pickblockpro.util.InfoProvider;
import io.github.sjouwer.pickblockpro.util.RaycastUtil;
import java.util.HashMap;
import java.util.StringJoiner;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1755;
import net.minecraft.class_1785;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1827;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_9275;
import net.minecraft.class_9334;

public class IdPicker {
    private static final class_310 client = class_310.method_1551();
    private static final ModConfig config = PickBlockPro.getConfig();

    private IdPicker() {
    }

    public static void pickId() {
        if (IdPicker.client.field_1724 == null || IdPicker.client.field_1687 == null) {
            PickBlockPro.LOGGER.error("Pick ID called outside of play; no world and/or player");
            return;
        }
        if (!config.idPickEntities() && !config.idPickBlocks()) {
            InfoProvider.sendError(class_2561.method_43471((String)"text.pickblockpro.message.nothingToPick"));
            return;
        }
        class_239 hit = RaycastUtil.getHit(config.blockIdPickRange((class_1657)IdPicker.client.field_1724), config.entityIdPickRange((class_1657)IdPicker.client.field_1724), !config.idPickFluids(), !config.idPickEntities());
        if (hit == null) {
            return;
        }
        class_5250 id = class_2561.method_43473();
        if (hit instanceof class_3966) {
            class_3966 entityHit = (class_3966)hit;
            id = IdPicker.getEntityDataAsText(entityHit.method_17782());
        }
        if (hit instanceof class_3965) {
            class_3965 blockHit = (class_3965)hit;
            if (config.idPickBlocks()) {
                id = IdPicker.getBlockDataAsText(blockHit.method_17777());
            }
        }
        if (id.getString().isEmpty()) {
            return;
        }
        if (config.copyToClipboard()) {
            IdPicker.client.field_1774.method_1455(id.getString());
            InfoProvider.sendMessage((class_2561)class_2561.method_43471((String)"text.pickblockpro.message.copied").method_27692(class_124.field_1077));
        }
        InfoProvider.sendMessage((class_2561)id);
    }

    private static class_2561 getEntityDataAsText(class_1297 entity) {
        return class_437.method_25441() && config.tagPickerEnabled() ? IdPicker.getEntityTag(entity) : IdPicker.getEntityId(entity);
    }

    private static class_2561 getBlockDataAsText(class_2338 blockPos) {
        class_2680 blockState = IdPicker.client.field_1687.method_8320(blockPos);
        if (class_437.method_25441() && config.tagPickerEnabled() && blockState.method_31709()) {
            class_2586 blockEntity = IdPicker.client.field_1687.method_8321(blockPos);
            return IdPicker.getBlockEntityTag(blockEntity);
        }
        return IdPicker.getBlockId(blockState);
    }

    public static class_2561 getBlockId(class_2680 blockState) {
        String fullId = class_7923.field_41175.method_10221((Object)blockState.method_26204()).toString();
        if (!config.addNamespace()) {
            fullId = fullId.substring(fullId.indexOf(":") + 1);
        }
        if (config.addProperties() && !blockState.method_28501().isEmpty()) {
            return class_2561.method_43470((String)fullId).method_10852(IdPicker.getBlockStateTag(blockState));
        }
        return class_2561.method_43470((String)fullId);
    }

    public static class_2561 getBlockStateTag(class_2680 blockState) {
        HashMap<String, String> properties = new HashMap<String, String>();
        for (class_2769 property : blockState.method_28501()) {
            String key = property.method_11899();
            if (config.blockStateTagIdBlacklist().contains(key)) continue;
            String value = blockState.method_11654(property).toString();
            properties.put(key, value);
        }
        return class_2561.method_43470((String)IdPicker.convertBlockState(new class_9275(properties)));
    }

    public static class_2561 getBlockEntityTag(class_2586 blockEntity) {
        class_2487 tag = blockEntity.method_38244((class_7225.class_7874)IdPicker.client.field_1687.method_30349());
        config.blockEntityTagIdBlacklist().forEach(arg_0 -> ((class_2487)tag).method_10551(arg_0));
        return config.prettyTagEnabled() ? class_2512.method_32270((class_2520)tag) : class_2561.method_43470((String)tag.toString());
    }

    public static class_2561 getEntityId(class_1297 entity) {
        String fullId = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        if (!config.addNamespace() && fullId.contains(":")) {
            fullId = fullId.substring(fullId.indexOf(":") + 1);
        }
        return class_2561.method_43470((String)fullId);
    }

    public static class_2561 getEntityTag(class_1297 entity) {
        class_2487 entityTag = DataComponentUtil.getEntityNbt(entity);
        config.entityTagIdBlacklist().forEach(arg_0 -> ((class_2487)entityTag).method_10551(arg_0));
        return config.prettyTagEnabled() ? class_2512.method_32270((class_2520)entityTag) : class_2561.method_43470((String)entityTag.toString());
    }

    public static String getItemId(class_1799 itemStack) {
        class_9275 blockState = (class_9275)itemStack.method_57353().method_57829(class_9334.field_49623);
        Object fullId = "";
        if (config.convertItemToBlock()) {
            fullId = IdPicker.convertToBlockId(itemStack, blockState);
        }
        if (((String)fullId).isEmpty()) {
            fullId = class_7923.field_41178.method_10221((Object)itemStack.method_7909()).toString();
        }
        if (!config.addNamespace()) {
            fullId = ((String)fullId).substring(((String)fullId).indexOf(":") + 1);
        }
        if (config.addProperties() && blockState != null) {
            fullId = (String)fullId + IdPicker.convertBlockState(blockState);
        }
        return fullId;
    }

    private static String convertBlockState(class_9275 blockState) {
        StringBuilder properties = new StringBuilder();
        StringJoiner stateJoiner = new StringJoiner(",");
        blockState.comp_2381().forEach((key, value) -> stateJoiner.add(key + "=" + value));
        properties.append("[");
        properties.append(stateJoiner);
        properties.append("]");
        return properties.toString();
    }

    private static String convertToBlockId(class_1799 itemStack, class_9275 blockState) {
        String id = "";
        class_1792 item = itemStack.method_7909();
        if (item instanceof class_1755 && !(item instanceof class_1785)) {
            class_3611 fluid = ((BucketItemAccessor)item).getFluid();
            id = class_7923.field_41173.method_10221((Object)fluid).toString();
        } else {
            class_2248 block = blockState != null && blockState.comp_2381().containsKey("facing") && item instanceof class_1827 ? ((VerticallyAttachableBlockItemAccessor)item).getWallBlock() : class_2248.method_9503((class_1792)item);
            if (block != class_2246.field_10124) {
                id = class_7923.field_41175.method_10221((Object)block).toString();
            }
        }
        return id;
    }
}

