/*
 * Decompiled with CFR 0.152.
 */
package smsk.smoothscroll;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.Expose;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Serializable;
import net.fabricmc.loader.api.FabricLoader;
import smsk.smoothscroll.SmoothSc;

public class Config {
    public static Cdata cfg;
    public static float cfgVersion;
    public static boolean problemReading;

    public Config() {
        File cfgfile = FabricLoader.getInstance().getConfigDir().resolve("smoothscroll.json").toFile();
        if (cfgfile.exists()) {
            cfg = this.readFile(cfgfile);
            if (cfg == null) {
                problemReading = true;
                SmoothSc.print("There was a problem reading the config file, using the default values.");
                cfg = new Cdata();
            }
        } else {
            SmoothSc.print("Config file not found, making a new one.");
            cfg = new Cdata();
            this.writeFile(cfgfile);
        }
        if (!problemReading) {
            if (Config.cfg.cfgVersion < cfgVersion) {
                SmoothSc.print("Config values before updating:\n" + this.printify());
            }
            if (Config.cfg.cfgVersion < 1.6f && Config.cfg.hotbarSpeed != 0.2f) {
                if (Config.cfg.hotbarSpeed != 0.0f) {
                    Config.cfg.hotbarSpeed = 1.0f / Config.cfg.hotbarSpeed;
                }
                if (Config.cfg.chatSpeed != 0.0f) {
                    Config.cfg.chatSpeed = 1.0f / Config.cfg.chatSpeed;
                }
                if (Config.cfg.creativeScreenSpeed != 0.0f) {
                    Config.cfg.creativeScreenSpeed = 1.0f / Config.cfg.creativeScreenSpeed;
                }
                if (Config.cfg.entryListSpeed != 0.0f) {
                    Config.cfg.entryListSpeed = 1.0f / Config.cfg.entryListSpeed;
                }
            }
            if (Config.cfg.cfgVersion < 1.9f && Config.cfg.entryListSpeed == 0.334f) {
                Config.cfg.entryListSpeed = 0.5f;
            }
            if (Config.cfg.cfgVersion < 1.91f) {
                Config.cfg.chatOpeningSpeed = Config.cfg.chatSpeed;
            }
            Config.cfg.cfgVersion = cfgVersion;
            Config.cfg.note = "Safe values for settings are 0 - 1 (inclusive). 0 means animation off (infinite speed) and bigger values mean slower speed (up to 1). Press F3+T in a world to update config.";
            this.writeFile(cfgfile);
        }
        if (SmoothSc.isSmoothScrollingRefurbishedLoaded) {
            Config.cfg.entryListSpeed = 0.0f;
            SmoothSc.print("Smooth Scrolling Refurbished is loaded! Disabling Entry List Smooth Scrolling in favor of the other mod.");
        }
        SmoothSc.print("Config values:\n" + this.printify());
    }

    Cdata readFile(File f) {
        InputStreamReader fr = null;
        Cdata ret = null;
        try {
            Gson gson = new Gson();
            fr = new FileReader(f);
            ret = (Cdata)gson.fromJson((Reader)fr, Cdata.class);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fr.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ret;
    }

    void writeFile(File f) {
        OutputStreamWriter fw = null;
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            fw = new FileWriter(f);
            fw.write(gson.toJson((Object)cfg));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            fw.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    String printify() {
        return "Hotbar speed: " + Config.cfg.hotbarSpeed + "\nChat speed: " + Config.cfg.chatSpeed + "\nChat Opening speed: " + Config.cfg.chatOpeningSpeed + "\nCreative screen speed: " + Config.cfg.creativeScreenSpeed + "\nEntry list speed: " + Config.cfg.entryListSpeed + "\nMask debug enabled: " + Config.cfg.enableMaskDebug + "\nConfig version: " + Config.cfg.cfgVersion;
    }

    static {
        cfgVersion = 2.1f;
        problemReading = false;
    }

    public class Cdata
    implements Serializable {
        @Expose
        public String note = "";
        @Expose
        public float hotbarSpeed = 0.2f;
        @Expose
        public float chatSpeed = 0.5f;
        @Expose
        public float chatOpeningSpeed = 0.5f;
        @Expose
        public float creativeScreenSpeed = 0.5f;
        @Expose
        public float entryListSpeed = 0.5f;
        @Expose
        public boolean enableMaskDebug = false;
        @Expose
        public float cfgVersion = 0.0f;
    }
}

