/*
 * Decompiled with CFR 0.152.
 */
package com.mikitellurium.potionsreglint.api;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import net.fabricmc.loader.api.FabricLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TelluriumConfig {
    private static final String fileExtension = ".properties";

    public static class RangedConfigEntry<T extends Number>
    extends ConfigEntry<T> {
        private final T minValue;
        private final T maxValue;

        private RangedConfigEntry(Builder parent, String key, T minValue, T maxValue, T defaultValue) {
            super(parent, key, defaultValue);
            this.minValue = minValue;
            this.maxValue = maxValue;
        }

        public T getMinValue() {
            return this.minValue;
        }

        public T getMaxValue() {
            return this.maxValue;
        }

        @Override
        public void setValue(T value) {
            if (this.compare(value, this.minValue) < 0) {
                super.setValue(this.minValue);
            } else if (this.compare(value, this.maxValue) > 0) {
                super.setValue(this.maxValue);
            } else {
                super.setValue(value);
            }
        }

        private int compare(T value1, T value2) {
            return ((Comparable)value1).compareTo(value2);
        }

        @Override
        public RangedConfigEntry<T> comment(String comment) {
            super.comment(comment);
            return this;
        }
    }

    public static class ConfigEntry<T> {
        private final Builder builder;
        private String comment;
        private final String key;
        private final T defaultValue;
        private T value;

        private ConfigEntry(Builder parent, String key, T defaultValue) {
            this.builder = parent;
            this.key = key;
            this.defaultValue = defaultValue;
        }

        public Builder getBuilder() {
            return this.builder;
        }

        public String getKey() {
            return this.key;
        }

        public T getDefaultValue() {
            return this.defaultValue;
        }

        public T getValue() {
            if (this.value == null || this.value.toString().isBlank()) {
                return this.defaultValue;
            }
            return this.value;
        }

        public void setValue(T value) {
            this.value = value;
        }

        public ConfigEntry<T> comment(String comment) {
            this.comment = comment;
            return this;
        }

        private String getComment() {
            return this.comment;
        }
    }

    public static class Builder {
        private final Logger logger;
        private final String file;
        private final List<String> COMMENTS = new ArrayList<String>();
        private final List<ConfigEntry> ENTRIES = new ArrayList<ConfigEntry>();

        public Builder(String fileName) {
            this.file = FabricLoader.getInstance().getConfigDir().resolve(fileName + TelluriumConfig.fileExtension).toString();
            this.logger = LoggerFactory.getLogger((String)fileName);
        }

        public String getConfigFilePath() {
            return this.file;
        }

        public Builder comment(String comment) {
            this.COMMENTS.add(comment);
            return this;
        }

        public ConfigEntry<Boolean> define(String key, boolean defaultValue) {
            ConfigEntry<Boolean> newEntry = new ConfigEntry<Boolean>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public ConfigEntry<Integer> define(String key, int defaultValue) {
            ConfigEntry<Integer> newEntry = new ConfigEntry<Integer>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public RangedConfigEntry<Integer> defineInRange(String key, int minValue, int maxValue, int defaultValue) {
            RangedConfigEntry<Integer> newEntry = new RangedConfigEntry<Integer>(this, key, minValue, maxValue, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public ConfigEntry<Double> define(String key, double defaultValue) {
            ConfigEntry<Double> newEntry = new ConfigEntry<Double>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public RangedConfigEntry<Double> defineInRange(String key, double minValue, double maxValue, double defaultValue) {
            RangedConfigEntry<Double> newEntry = new RangedConfigEntry<Double>(this, key, minValue, maxValue, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public ConfigEntry<Long> define(String key, long defaultValue) {
            ConfigEntry<Long> newEntry = new ConfigEntry<Long>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public RangedConfigEntry<Long> defineInRange(String key, long minValue, long maxValue, long defaultValue) {
            RangedConfigEntry<Long> newEntry = new RangedConfigEntry<Long>(this, key, minValue, maxValue, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public ConfigEntry<String> define(String key, String defaultValue) {
            ConfigEntry<String> newEntry = new ConfigEntry<String>(this, key, defaultValue);
            this.ENTRIES.add(newEntry);
            return newEntry;
        }

        public void build() {
            File file = new File(this.file);
            if (file.exists()) {
                this.load();
            }
            this.save();
        }

        public void save() {
            try {
                FileWriter writer = new FileWriter(this.file);
                String newline = System.lineSeparator();
                if (this.COMMENTS.size() > 0) {
                    for (String s : this.COMMENTS) {
                        writer.write("#" + s + newline);
                    }
                }
                writer.write(newline);
                writer.write("[Settings]" + newline);
                writer.write(newline);
                if (this.ENTRIES.size() > 0) {
                    for (ConfigEntry entry : this.ENTRIES) {
                        String entrySeparator = "=";
                        if (entry.getComment() != null) {
                            writer.write("# " + entry.getComment() + newline);
                        }
                        if (entry instanceof RangedConfigEntry) {
                            writer.write("# Range: min=" + String.valueOf(((RangedConfigEntry)entry).getMinValue()) + ", max=" + String.valueOf(((RangedConfigEntry)entry).getMaxValue()) + newline);
                        }
                        writer.write("# default = " + String.valueOf(entry.getDefaultValue()) + newline);
                        writer.write(entry.getKey() + entrySeparator + String.valueOf(entry.getValue()) + newline);
                        writer.write(newline);
                    }
                }
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                this.logger.error("Something went wrong when trying to write config file \"" + this.getConfigFilePath() + "\"");
                e.printStackTrace();
            }
        }

        private void load() {
            try {
                File file = new File(this.file);
                Scanner reader = new Scanner(file);
                int line = 1;
                while (reader.hasNextLine()) {
                    this.parseConfigEntry(reader.nextLine(), line);
                    ++line;
                }
            }
            catch (IOException e) {
                this.logger.error("Something went wrong when trying to read config file \"" + this.getConfigFilePath() + "\"");
                e.printStackTrace();
            }
        }

        private void parseConfigEntry(String string, int line) {
            if (this.isValueLine(string)) {
                String[] entryParts = string.split("=", 2);
                if (entryParts.length == 2) {
                    ConfigEntry<?> configEntry = this.getConfigEntry(entryParts[0]);
                    if (configEntry != null) {
                        try {
                            Class<?> valueType = configEntry.getValue().getClass();
                            switch (valueType.getSimpleName()) {
                                case "Boolean": {
                                    configEntry.setValue(Boolean.parseBoolean(entryParts[1]));
                                    break;
                                }
                                case "Integer": {
                                    configEntry.setValue(Integer.parseInt(entryParts[1]));
                                    break;
                                }
                                case "Double": {
                                    configEntry.setValue(Double.parseDouble(entryParts[1]));
                                    break;
                                }
                                case "Long": {
                                    configEntry.setValue(Long.parseLong(entryParts[1]));
                                    break;
                                }
                                case "String": {
                                    configEntry.setValue(String.valueOf(entryParts[1]));
                                    break;
                                }
                                default: {
                                    configEntry.setValue(configEntry.getDefaultValue());
                                    break;
                                }
                            }
                        }
                        catch (NumberFormatException e) {
                            configEntry.setValue(configEntry.getDefaultValue());
                        }
                    } else {
                        this.logger.error("Unknown entry found: \"" + entryParts[0] + "\" in config file \"" + this.getConfigFilePath() + "\" at line " + line + ". Removing it.");
                    }
                } else {
                    this.logger.error("Unknown entry found: \"" + entryParts[0] + "\" in config file \"" + this.getConfigFilePath() + "\" at line " + line + ". Removing it.");
                }
            }
        }

        private ConfigEntry<?> getConfigEntry(String key) {
            for (ConfigEntry entry : this.ENTRIES) {
                if (!entry.getKey().equals(key)) continue;
                return entry;
            }
            return null;
        }

        private boolean isValueLine(String line) {
            if (line.isEmpty()) {
                return false;
            }
            return !line.startsWith("#") && !line.startsWith("[");
        }
    }
}

