/*
 * Decompiled with CFR 0.152.
 */
package nl.enjarai.doabarrelroll.net;

import com.mojang.serialization.Codec;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.server.MinecraftServer;
import nl.enjarai.doabarrelroll.DoABarrelRoll;
import nl.enjarai.doabarrelroll.config.LimitedModConfigServer;
import nl.enjarai.doabarrelroll.config.ModConfigServer;
import nl.enjarai.doabarrelroll.net.ServerConfigHolder;
import nl.enjarai.doabarrelroll.net.packet.ConfigResponseC2SPacket;
import nl.enjarai.doabarrelroll.net.packet.ConfigSyncS2CPacket;
import nl.enjarai.doabarrelroll.util.DelayedRunnable;

public class HandshakeServer<P extends ConfigSyncS2CPacket> {
    public static final int PROTOCOL_VERSION = 4;
    private final PacketConstructor<P> packetConstructor;
    private final ServerConfigHolder configHolder;
    private final Map<class_3244, ClientInfo> syncStates = new WeakHashMap<class_3244, ClientInfo>();
    private final Map<class_3244, DelayedRunnable> scheduledKicks = new WeakHashMap<class_3244, DelayedRunnable>();
    private final Function<class_3244, Boolean> getsLimitedCheck;
    private final Codec<ModConfigServer> transferCodec = ModConfigServer.CODEC;
    private final Codec<LimitedModConfigServer> limitedTransferCodec = LimitedModConfigServer.getCodec();

    public HandshakeServer(PacketConstructor<P> packetConstructor, ServerConfigHolder configHolder, Function<class_3244, Boolean> getsLimitedCheck) {
        this.packetConstructor = packetConstructor;
        this.configHolder = configHolder;
        this.getsLimitedCheck = getsLimitedCheck;
    }

    public void tick(MinecraftServer server) {
        Iterator<Map.Entry<class_3244, DelayedRunnable>> it = this.scheduledKicks.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<class_3244, DelayedRunnable> entry = it.next();
            if (entry.getValue().isDone()) {
                it.remove();
                continue;
            }
            entry.getValue().tick();
        }
    }

    public ClientInfo getHandshakeState(class_3222 player) {
        return this.getHandshakeState(player.field_13987);
    }

    public ClientInfo getHandshakeState(class_3244 handler) {
        return this.syncStates.computeIfAbsent(handler, key -> new ClientInfo(HandshakeState.NOT_SENT, 4, true));
    }

    public P initiateConfigSync(class_3244 handler) {
        Boolean isLimited = this.getsLimitedCheck.apply(handler);
        this.getHandshakeState((class_3244)handler).isLimited = isLimited;
        ModConfigServer config = this.configHolder.instance;
        return this.packetConstructor.construct(4, config, isLimited, isLimited != false ? ModConfigServer.DEFAULT : config);
    }

    public void configSentToClient(class_3244 handler) {
        this.getHandshakeState((class_3244)handler).state = HandshakeState.SENT;
        ModConfigServer config = this.configHolder.instance;
        if (config.getSyncTimeout() != null) {
            this.scheduledKicks.put(handler, new DelayedRunnable(config.getSyncTimeout(), () -> {
                if (this.getHandshakeState((class_3244)handler).state != HandshakeState.ACCEPTED) {
                    DoABarrelRoll.LOGGER.warn("{} did not accept config syncing, config indicates we kick them.", (Object)handler.method_32311().method_5477().getString());
                    handler.method_52396(config.getSyncTimeoutMessage());
                }
            }));
        }
    }

    public HandshakeState clientReplied(class_3244 handler, ConfigResponseC2SPacket packet) {
        ClientInfo info = this.getHandshakeState(handler);
        class_3222 player = handler.method_32311();
        if (info.state == HandshakeState.SENT) {
            int protocolVersion = packet.protocolVersion();
            if (protocolVersion < 1 || protocolVersion > 4) {
                DoABarrelRoll.LOGGER.warn("Client of {} sent unknown protocol version, expected range 1-{}, got {}. Will attempt to proceed anyway.", new Object[]{player.method_5477().getString(), 4, protocolVersion});
            }
            if (protocolVersion == 2 && info.protocolVersion != 2) {
                DoABarrelRoll.LOGGER.info("Client of {} is using an older protocol version, resending.", (Object)player.method_5477().getString());
                info.state = HandshakeState.RESEND;
            } else if (packet.success()) {
                DoABarrelRoll.LOGGER.info("Client of {} accepted server config.", (Object)player.method_5477().getString());
                info.state = HandshakeState.ACCEPTED;
            } else {
                DoABarrelRoll.LOGGER.warn("Client of {} failed to process server config, check client logs find what went wrong.", (Object)player.method_5477().getString());
                info.state = HandshakeState.FAILED;
            }
            info.protocolVersion = protocolVersion;
        }
        return info.state;
    }

    public void playerDisconnected(class_3244 handler) {
        this.syncStates.remove(handler);
    }

    public static interface PacketConstructor<P extends ConfigSyncS2CPacket> {
        public P construct(int var1, LimitedModConfigServer var2, boolean var3, ModConfigServer var4);
    }

    public static class ClientInfo {
        public HandshakeState state;
        public int protocolVersion;
        public boolean isLimited;

        public ClientInfo(HandshakeState state, int protocolVersion, boolean isLimited) {
            this.state = state;
            this.protocolVersion = protocolVersion;
            this.isLimited = isLimited;
        }
    }

    public static enum HandshakeState {
        NOT_SENT,
        SENT,
        ACCEPTED,
        FAILED,
        RESEND;

    }
}

