/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.utils.skin;

import com.mojang.authlib.GameProfile;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.mixin.cache_skin_getter.PlayerSkinTextureAccessor;
import fzmm.zailer.me.utils.FzmmUtils;
import fzmm.zailer.me.utils.skin.SkinGetterDecorator;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.ExecutionException;
import javax.imageio.ImageIO;
import net.minecraft.class_1044;
import net.minecraft.class_1046;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_640;
import net.minecraft.class_8685;

public class CacheSkinGetter
extends SkinGetterDecorator {
    public CacheSkinGetter(SkinGetterDecorator skinGetterDecorator) {
        super(skinGetterDecorator);
    }

    public CacheSkinGetter() {
    }

    @Override
    public Optional<BufferedImage> getSkin(String playerName) {
        Optional<GameProfile> profileOptional = this.getProfile(playerName);
        if (profileOptional.isEmpty()) {
            return super.getSkin(playerName);
        }
        Optional<BufferedImage> cacheSkin = this.getSkin(profileOptional.get());
        return cacheSkin.isPresent() ? cacheSkin : super.getSkin(playerName);
    }

    public Optional<BufferedImage> getSkin(GameProfile profile) {
        class_8685 textures;
        class_310 client = class_310.method_1551();
        assert (client.field_1724 != null);
        try {
            textures = (class_8685)client.method_1582().method_52863(profile).get();
        }
        catch (InterruptedException | ExecutionException ignored) {
            return Optional.empty();
        }
        class_1044 texture = client.method_1531().method_4619(textures.comp_1626());
        if (!(texture instanceof class_1046)) {
            return Optional.empty();
        }
        class_1046 skinTexture = (class_1046)texture;
        File skinFile = ((PlayerSkinTextureAccessor)skinTexture).getCacheFile();
        try {
            return Optional.of(ImageIO.read(skinFile));
        }
        catch (IOException ignored) {
            return Optional.empty();
        }
    }

    @Override
    public Optional<class_1799> getHead(String playerName) {
        Optional<GameProfile> profile = this.getProfile(playerName);
        return profile.map(HeadBuilder::of).or(() -> super.getHead(playerName));
    }

    @Override
    protected Optional<GameProfile> getProfile(String playerName) {
        class_640 playerListEntry = FzmmUtils.getOnlinePlayer(playerName);
        if (playerListEntry == null) {
            return Optional.empty();
        }
        return Optional.of(playerListEntry.method_2966());
    }
}

