/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.compat.symbol_chat;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.client.gui.components.style.StyledContainers;
import fzmm.zailer.me.compat.CompatMods;
import fzmm.zailer.me.compat.symbol_chat.SymbolChatCompat;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.VanillaWidgetComponent;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import org.jetbrains.annotations.Nullable;

public class SymbolChatComponentHandler<T extends VanillaWidgetComponent> {
    @Nullable
    private T component;
    private final class_2561 buttonText;
    private final class_2561 buttonTooltip;
    private final class_2561 notAvailableTooltip;
    private final SymbolChatCompat compat;

    public SymbolChatComponentHandler(SymbolChatCompat compat, class_2561 buttonText, class_2561 buttonTooltip, class_2561 notAvailableTooltip) {
        this.compat = compat;
        this.buttonText = buttonText;
        this.buttonTooltip = buttonTooltip;
        this.notAvailableTooltip = buttonTooltip.method_27661().method_27693("\n\n").method_10852(notAvailableTooltip);
    }

    public Component initButton(BaseFzmmScreen screen, class_342 selectedComponent, Supplier<T> componentSupplier) {
        ButtonComponent result = Components.button((class_2561)this.buttonText, button -> this.buttonExecute(screen, selectedComponent, componentSupplier));
        result.sizing(Sizing.fixed((int)20));
        result.field_22763 = CompatMods.SYMBOL_CHAT_PRESENT;
        if (CompatMods.SYMBOL_CHAT_PRESENT) {
            result.tooltip(this.buttonTooltip);
        } else {
            result = StyledContainers.horizontalFlow(Sizing.content(), Sizing.content()).child((Component)result).tooltip(this.notAvailableTooltip);
        }
        return result;
    }

    protected void buttonExecute(BaseFzmmScreen screen, class_342 selectedComponent, Supplier<T> componentSupplier) {
        if (!CompatMods.SYMBOL_CHAT_PRESENT) {
            return;
        }
        try {
            if (this.isMounted()) {
                class_342 newSelected = selectedComponent;
                if (this.compat.selectedComponent() == newSelected) {
                    this.remove();
                    newSelected = null;
                }
                this.compat.selectedComponent(newSelected);
                return;
            }
            this.compat.font().remove();
            this.compat.symbol().remove();
            this.compat.selectedComponent(selectedComponent);
            this.component = (VanillaWidgetComponent)componentSupplier.get();
            screen.child((Component)this.component.positioning(Positioning.absolute((int)0, (int)0)));
        }
        catch (NoClassDefFoundError | NoSuchMethodError e) {
            CompatMods.SYMBOL_CHAT_PRESENT = false;
            FzmmClient.LOGGER.error("[SymbolChatComponent] Failed to create component", (Throwable)e);
        }
    }

    public boolean isMounted() {
        if (!CompatMods.SYMBOL_CHAT_PRESENT || this.component == null) {
            return false;
        }
        return this.component.hasParent();
    }

    public void remove() {
        if (!CompatMods.SYMBOL_CHAT_PRESENT || this.component == null) {
            return;
        }
        this.component.remove();
        this.component = null;
    }

    public boolean charTyped(char chr, int modifiers) {
        return this.component != null && this.component.onCharTyped(chr, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return this.component != null && this.component.onKeyPress(keyCode, scanCode, modifiers);
    }

    public Optional<T> getComponent() {
        return Optional.ofNullable(this.component);
    }
}

