/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.compat.symbol_chat;

import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.BaseFzmmScreen;
import fzmm.zailer.me.compat.CompatMods;
import fzmm.zailer.me.compat.symbol_chat.SymbolChatComponentHandler;
import fzmm.zailer.me.compat.symbol_chat.components.FontComponentAdapter;
import fzmm.zailer.me.compat.symbol_chat.components.SymbolComponentAdapter;
import io.wispforest.owo.ui.core.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_342;
import net.replaceitem.symbolchat.SymbolChat;
import net.replaceitem.symbolchat.gui.SymbolSelectionPanel;
import net.replaceitem.symbolchat.gui.widget.DropDownWidget;
import net.replaceitem.symbolchat.resource.FontProcessor;
import org.jetbrains.annotations.Nullable;

public class SymbolChatCompat {
    private static final class_2561 SYMBOL_CHAT_NOT_AVAILABLE_TEXT_TOOLTIP = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.notAvailable.tooltip").method_10862(class_2583.field_24360.method_36139(15867917));
    private static final class_2561 SYMBOL_BUTTON_TEXT = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.symbol");
    private static final class_2561 SYMBOL_BUTTON_TEXT_TOOLTIP = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.symbol.tooltip");
    private static final class_2561 FONT_BUTTON_TEXT = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.font");
    private static final class_2561 FONT_BUTTON_TEXT_TOOLTIP = class_2561.method_43471((String)"fzmm.gui.button.symbolChat.font.tooltip");
    private class_342 selectedComponent = null;
    private final SymbolChatComponentHandler<SymbolComponentAdapter> symbolHandler = new SymbolChatComponentHandler(this, SYMBOL_BUTTON_TEXT, SYMBOL_BUTTON_TEXT_TOOLTIP, SYMBOL_CHAT_NOT_AVAILABLE_TEXT_TOOLTIP);
    private final SymbolChatComponentHandler<FontComponentAdapter> fontHandler = new SymbolChatComponentHandler(this, FONT_BUTTON_TEXT, FONT_BUTTON_TEXT_TOOLTIP, SYMBOL_CHAT_NOT_AVAILABLE_TEXT_TOOLTIP);

    public List<Component> getButtons(BaseFzmmScreen screen, class_342 selectedComponent) {
        ArrayList<Component> result = new ArrayList<Component>();
        if (FzmmClient.CONFIG.general.showSymbolButton()) {
            result.add(this.fontHandler.initButton(screen, selectedComponent, this::getFontComponent));
            result.add(this.symbolHandler.initButton(screen, selectedComponent, this::getSymbolComponent));
        }
        return result;
    }

    private SymbolComponentAdapter getSymbolComponent() {
        return new SymbolComponentAdapter(new SymbolSelectionPanel(0, 0, SymbolChat.config.getSymbolPanelHeight(), s -> {
            if (this.selectedComponent != null) {
                this.selectedComponent.method_1867(s);
            }
        }));
    }

    private FontComponentAdapter getFontComponent() {
        return new FontComponentAdapter((DropDownWidget<FontProcessor>)new DropDownWidget(0, 0, 180, 15, SymbolChat.fontManager.getFontProcessors(), SymbolChat.selectedFont));
    }

    public class_342 selectedComponent() {
        return this.selectedComponent;
    }

    public SymbolChatComponentHandler<SymbolComponentAdapter> symbol() {
        return this.symbolHandler;
    }

    public SymbolChatComponentHandler<FontComponentAdapter> font() {
        return this.fontHandler;
    }

    public void selectedComponent(@Nullable class_342 selectedComponent) {
        this.selectedComponent = selectedComponent;
    }

    public boolean charTyped(char chr, int modifiers) {
        if (!CompatMods.SYMBOL_CHAT_PRESENT) {
            return false;
        }
        return this.symbolHandler.charTyped(chr, modifiers) || this.fontHandler.charTyped(chr, modifiers);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (!CompatMods.SYMBOL_CHAT_PRESENT) {
            return false;
        }
        return this.symbolHandler.keyPressed(keyCode, scanCode, modifiers) || this.fontHandler.keyPressed(keyCode, scanCode, modifiers);
    }

    public void processFont(class_342 widget, String text, Consumer<String> writeConsumer) {
        if (!CompatMods.SYMBOL_CHAT_PRESENT || this.selectedComponent != widget || !this.fontHandler.isMounted()) {
            writeConsumer.accept(text);
            return;
        }
        this.fontHandler.getComponent().ifPresent(fontComponentAdapter -> fontComponentAdapter.processFont(widget, text, writeConsumer));
    }
}

