/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.player_statue;

import fzmm.zailer.me.builders.ArmorStandBuilder;
import fzmm.zailer.me.builders.HeadBuilder;
import fzmm.zailer.me.client.FzmmClient;
import fzmm.zailer.me.client.gui.options.HorizontalDirectionOption;
import fzmm.zailer.me.client.logic.player_statue.StatuePartEnum;
import fzmm.zailer.me.client.logic.player_statue.statue_head_skin.AbstractStatueSkinManager;
import fzmm.zailer.me.client.logic.player_statue.statue_head_skin.HeadModelSkin;
import fzmm.zailer.me.utils.HeadUtils;
import fzmm.zailer.me.utils.position.PosF;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import org.joml.Vector3f;

public class StatuePart {
    public static final String PLAYER_STATUE_TAG = "PlayerStatue";
    private static final String DEFAULT_SKIN_VALUE = "Error!";
    private static final float Z_FIGHT_FIX_DISTANCE = 1.0E-5f;
    private final HeadModelSkin headModelSkin;
    private final StatuePartEnum part;
    private final String name;
    private final HorizontalDirectionOption direction;
    private PosF basePos;
    private final int headHeight;
    private int rotation;
    private final short zFightX;
    private final short zFightY;
    private final short zFightZ;
    private boolean skinGenerated;
    private String skinValue;
    private final BufferedImage headSkin;
    private AbstractStatueSkinManager skinManager;

    public StatuePart(StatuePartEnum part, String name, int headHeight, HeadModelSkin headModelSkin, int zFightX, int zFightY, int zFightZ, AbstractStatueSkinManager skinManager) {
        this.part = part;
        this.name = name;
        this.direction = HorizontalDirectionOption.NORTH;
        this.basePos = new PosF(Float.valueOf(0.0f), Float.valueOf(0.0f));
        this.headHeight = headHeight;
        this.rotation = 0;
        this.zFightX = (short)zFightX;
        this.zFightY = (short)zFightY;
        this.zFightZ = (short)zFightZ;
        this.skinGenerated = false;
        this.skinValue = DEFAULT_SKIN_VALUE;
        this.headModelSkin = HeadModelSkin.of(this.part.getDefaultHeadModel(), headModelSkin);
        this.setDirection(HorizontalDirectionOption.NORTH);
        this.headSkin = new BufferedImage(64, 64, 2);
        this.skinManager = skinManager;
    }

    public StatuePart(StatuePartEnum part, String name, int headHeight, int zFightX, int zFightY, int zFightZ, HorizontalDirectionOption direction, String skinValue) {
        this.part = part;
        this.name = name;
        this.direction = direction;
        this.basePos = new PosF(Float.valueOf(0.0f), Float.valueOf(0.0f));
        this.headHeight = headHeight;
        this.rotation = 0;
        this.zFightX = (short)zFightX;
        this.zFightY = (short)zFightY;
        this.zFightZ = (short)zFightZ;
        this.skinGenerated = true;
        this.skinValue = skinValue;
        this.headModelSkin = null;
        this.headSkin = null;
        this.setDirection(this.direction);
    }

    private class_2487 writePlayerStatueTag() {
        class_2487 playerStatueTag = new class_2487();
        class_2487 zFight = new class_2487();
        zFight.method_10569("x", (int)this.zFightX);
        zFight.method_10569("y", (int)this.zFightY);
        zFight.method_10569("z", (int)this.zFightZ);
        playerStatueTag.method_10569("headHeight", this.headHeight);
        playerStatueTag.method_10569("direction", this.direction.ordinal());
        playerStatueTag.method_10582("part", this.part.toString());
        playerStatueTag.method_10582("name", this.name);
        playerStatueTag.method_10582("skinValue", this.skinValue);
        playerStatueTag.method_10566("zFight", (class_2520)zFight);
        return playerStatueTag;
    }

    private class_2487 writeFzmmTag() {
        class_2487 playerStatueTag = this.writePlayerStatueTag();
        class_2487 fzmmTag = new class_2487();
        fzmmTag.method_10566(PLAYER_STATUE_TAG, (class_2520)playerStatueTag);
        return fzmmTag;
    }

    public static StatuePart ofItem(class_1799 stack) {
        class_2487 customDataTag = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)new class_2487()))).method_57461();
        class_2487 fzmmTag = customDataTag.method_10562("FZMM_MOD");
        class_2487 playerStatueTag = fzmmTag.method_10562(PLAYER_STATUE_TAG);
        class_2487 zFight = playerStatueTag.method_10562("zFight");
        StatuePartEnum part = StatuePartEnum.get(playerStatueTag.method_10558("part"));
        String name = playerStatueTag.method_10558("name");
        int headHeight = playerStatueTag.method_10550("headHeight");
        HorizontalDirectionOption direction = HorizontalDirectionOption.values()[playerStatueTag.method_10550("direction")];
        String skinValue = playerStatueTag.method_10558("skinValue");
        int x = zFight.method_10550("x");
        int y = zFight.method_10550("y");
        int z = zFight.method_10550("z");
        return new StatuePart(part, name, headHeight, x, y, z, direction, skinValue);
    }

    public static boolean isStatue(class_1799 stack) {
        class_2487 customDataTag = ((class_9279)stack.method_57825(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)new class_2487()))).method_57461();
        class_2487 fzmmTag = customDataTag.method_10562("FZMM_MOD");
        if (!fzmmTag.method_10573(PLAYER_STATUE_TAG, 10)) {
            return false;
        }
        class_2487 playerStatueTag = fzmmTag.method_10562(PLAYER_STATUE_TAG);
        if (!playerStatueTag.method_10573("part", 8)) {
            return false;
        }
        if (!playerStatueTag.method_10573("name", 8)) {
            return false;
        }
        if (!playerStatueTag.method_10573("headHeight", 3)) {
            return false;
        }
        if (!playerStatueTag.method_10573("direction", 3)) {
            return false;
        }
        int directionOrdinal = playerStatueTag.method_10550("direction");
        if (class_2350.values().length < directionOrdinal) {
            return false;
        }
        if (!playerStatueTag.method_10573("skinValue", 8)) {
            return false;
        }
        if (!playerStatueTag.method_10573("zFight", 10)) {
            return false;
        }
        class_2487 zFight = playerStatueTag.method_10562("zFight");
        return zFight.method_10573("x", 3) && zFight.method_10573("y", 3) && zFight.method_10573("z", 3);
    }

    public String getName() {
        return this.name;
    }

    public class_1799 get(Vector3f pos, HorizontalDirectionOption direction) {
        if (!this.isSkinGenerated()) {
            return new class_1799((class_1935)class_1802.field_8077);
        }
        this.setDirection(direction);
        this.fixZFight(pos);
        float x = pos.x() + ((Float)this.basePos.getX()).floatValue();
        float y = pos.y() + (float)this.headHeight * 0.25f - 0.9f;
        float z = pos.z() + ((Float)this.basePos.getY()).floatValue();
        class_1799 statuePart = ArmorStandBuilder.builder().setPos(x, y, z).setImmutableAndInvisible().setRightArmPose(new Vector3f(-45.0f, (float)this.rotation, 0.0f)).setRightHandItem(HeadBuilder.builder().skinValue(this.skinValue).get()).setTags(PLAYER_STATUE_TAG).getItem(this.name);
        statuePart.method_57368(class_9334.field_49628, (Object)class_9279.field_49302, nbtComponent -> {
            class_2487 result = nbtComponent.method_57461();
            result.method_10566("FZMM_MOD", (class_2520)this.writeFzmmTag());
            return class_9279.method_57456((class_2487)result);
        });
        return statuePart;
    }

    public CompletableFuture<Integer> setStatueSkin(BufferedImage playerSkin, int scale) {
        this.draw(playerSkin, this.headSkin, scale);
        return new HeadUtils().uploadHead(this.headSkin, this.name).thenApply(headUtils -> {
            this.skinValue = headUtils.getSkinValue();
            this.skinGenerated = headUtils.isSkinGenerated();
            if (!this.skinGenerated) {
                FzmmClient.LOGGER.error("[StatuePart] The statue {} had an error generating its skin", (Object)this.name);
            }
            return headUtils.getDelayForNext(TimeUnit.MILLISECONDS);
        });
    }

    public boolean isSkinGenerated() {
        return this.skinGenerated;
    }

    private void draw(BufferedImage playerSkin, BufferedImage destinationSkin, int scale) {
        Graphics2D graphics = destinationSkin.createGraphics();
        this.headModelSkin.draw(this.skinManager, graphics, playerSkin, scale);
    }

    private void fixZFight(Vector3f pos) {
        pos.add((float)this.zFightX * 1.0E-5f, (float)this.zFightY * 1.0E-5f, (float)this.zFightZ * 1.0E-5f);
    }

    private void setDirection(HorizontalDirectionOption direction) {
        PosF newPos = switch (direction) {
            case HorizontalDirectionOption.EAST -> {
                this.basePos = new PosF(Float.valueOf(0.93f), Float.valueOf(0.7f));
                this.rotation = -135;
                yield this.part.getEast();
            }
            case HorizontalDirectionOption.SOUTH -> {
                this.basePos = new PosF(Float.valueOf(-0.01f), Float.valueOf(0.6f));
                this.rotation = -45;
                yield this.part.getSouth();
            }
            case HorizontalDirectionOption.WEST -> {
                this.basePos = new PosF(Float.valueOf(0.08f), Float.valueOf(-0.33f));
                this.rotation = 45;
                yield this.part.getWest();
            }
            default -> {
                this.basePos = new PosF(Float.valueOf(1.01f), Float.valueOf(-0.25f));
                this.rotation = 135;
                yield this.part.getNorth();
            }
        };
        this.basePos.add(newPos);
    }

    public static class PlayerStatueTags {
        public static final String NAME = "name";
        public static final String PART = "part";
        public static final String HEAD_HEIGHT = "headHeight";
        public static final String Z_FIGHT = "zFight";
        public static final String DIRECTION = "direction";
        public static final String SKIN_VALUE = "skinValue";
        public static final String NAME_TAG = "nameTag";
    }
}

