/*
 * Decompiled with CFR 0.152.
 */
package fzmm.zailer.me.client.logic.imagetext;

import java.awt.Color;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;

public final class ImagetextLineComponent {
    private final int pixelColor;
    private short repetitions;

    public ImagetextLineComponent(int pixelColor) {
        this.pixelColor = pixelColor;
        this.repetitions = 1;
    }

    public boolean tryAdd(int color, double percentageOfSimilarity) {
        if (!this.isSimilar(color, percentageOfSimilarity)) {
            return false;
        }
        this.repetitions = (short)(this.repetitions + 1);
        return true;
    }

    public boolean isSimilar(int color, double percentageOfSimilarity) {
        int colorSum;
        if (this.pixelColor == color) {
            return true;
        }
        Color pixelColor = new Color(this.pixelColor, true);
        int a1 = pixelColor.getAlpha();
        int r1 = pixelColor.getRed();
        int g1 = pixelColor.getGreen();
        int b1 = pixelColor.getBlue();
        Color colorObj = new Color(color, true);
        int a2 = colorObj.getAlpha();
        int r2 = colorObj.getRed();
        int g2 = colorObj.getGreen();
        int b2 = colorObj.getBlue();
        int colorsDifference = this.getDifference(r1, r2) + this.getDifference(g1, g2) + this.getDifference(b1, b2) + this.getDifference(a1, a2);
        return (double)colorsDifference * 100.0 / (double)(colorSum = a1 + r1 + g1 + b1) < percentageOfSimilarity;
    }

    private int getDifference(int n, int n2) {
        return Math.abs(n - n2);
    }

    public short getRepetitions() {
        return this.repetitions;
    }

    public class_2561 getText(String[] charactersToUse, int lineIndex, boolean isDefaultText) {
        int alpha = this.pixelColor >> 24 & 0xFF;
        return isDefaultText && alpha < 128 ? this.getEmptyText() : this.getText(charactersToUse, lineIndex);
    }

    public class_2561 getEmptyText() {
        String spaceString = " ".repeat(this.repetitions);
        return class_2561.method_43470((String)(spaceString + String.valueOf(class_124.field_1067) + spaceString + String.valueOf(class_124.field_1070)));
    }

    private class_2561 getText(String[] charactersToUse, int lineIndex) {
        StringBuilder textStrBuilder = new StringBuilder();
        int colorRGB = this.pixelColor & 0xFFFFFF;
        for (int x = 0; x != this.repetitions; ++x) {
            textStrBuilder.append(this.getCharacter(charactersToUse, lineIndex++));
        }
        return class_2561.method_43470((String)textStrBuilder.toString()).method_10862(class_2583.field_24360.method_36139(colorRGB));
    }

    private String getCharacter(String[] charactersToUse, int index) {
        return charactersToUse[index % charactersToUse.length];
    }
}

